unit TPW32;
{ *** version 2.00: November 30 1998, by Prof A Olowofoyeku *** }

{
Original message by Christian Ghisler: (in LONGNAME.PAS)
--------------------------------------
Functions to use long filenames}
{All functions start with "W32" to distinguish them from 16 bit functions}
{To call a function, use it like a normal function, with one exception:
 the last parameter must be the id value for that function. Example:
 longhandle:=W32FindFirstFile('c:\*.*',finddata,id_W32FindFirstFile);}

{VERY IMPORTANT: All these functions work fine on Windows 95, but NOT all work on
 Windows NT:
 - W32SetCurrentDirectory returns true, but does NOT actually change the current directory

 all other functions seem to work fine, but test your application on NT before saying that
 it runs fine!


New message by Prof A Olowofoyeku:
----------------------------------

FILE: TPW32.PAS

Purpose:
This unit implements some functions in the Win32 API, which can be called
from BPW or Delphi programs. The functions implemented here are few and
mainly serve my own purposes. I have added some functions of my own, for
my own programming needs. Some of them involve big kludges, but they seem
to work. Your mileage may vary.

This has been tested only under BPW - but it should work with Delphi
- you may need to replace "WinDos.xxx" with "SysUtils.xxx"

HISTORY-
1. Original translation by Christian Ghisler
2. More Win32 API functions added by Prof A Olowofoyeku
3. Some general functions written by Prof A Olowofoyeku
4. Some functions supplied courtesy of Claus Ziegler
}

interface
{F+,G+,I-}

uses
W32Types;

{/////// exported variables /////}
Var
IsWindowsNT,    {Are we running Windows NT?}
IsWindows95,    {Are we running Windows 95?}
IsWindows98     {Windows 98?}
:Boolean;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////// Prof Olowofoyeku's own functions ////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Function IsWin32OS:Boolean;
{Return whether we can use 32-bit functions or not; if ANY of the
Win32 API functions fails to initialise correctly, this function
will return false}

Function  SetWin32OSValue(Const Enable:Boolean):Boolean;
{change Win32 support on the fly; returns the old value of Use32Bit}

Function Stupcase(Const s:String):String;
{convert a string to uppercase}

Function W32Exist(Var FName:String):Boolean;
{does a file exist? if so, return its full path}

Function W32IsDirectory(Var DirName:String):Boolean;
{does a directory exist? if so, return its full path}

Function W32Rename(TheOld, TheNew:String):longbool;
{rename a file; with longname support}

Function W32Move(TheOld, TheNew:String):longbool;
{move a file, by renaming it; if TheNew exists,
it will try to delete it and then do a rename}

Function StripQuotes(s:String):String;
{remove quotation marks from a string and return the result}

Function StripChar(s:string;ch:char):string;
{remove all occurences of "ch" from "s", and return the result}

Function W32WinExec(p:Pchar;mode:longint):longint;
{winexec for win32}

Function ThisDrive:String;
{Return the current drive: e.g., "C:", "D:"}

function isUNC(Const s:string):boolean;
{is a drive a UNC name?}

Function IsUNCP(aName:pChar):Boolean;
{is a drive a UNC name? - use PChar instead of string}

Function W32FullPathName(s:string):String;
{return full path for a file you know to exist}

Function AddBackSlash(s:String):String;
{add a back slash to a path name}

Function AddNull(S:String):String;
{add a null character (#0) to a string}

Function Str2PChar(Var S:String):PChar;
{convert a string to a pchar}

Function IsWinNT : Boolean;
{Are we running Windows NT?}

Function W32MkDir(s:String): longint;
{make a directory - with long filename support}

Function W32Chdir(s:String): longint;
{change to a directory - with long filename support}

Function W32RmDir(s:String): longint;
{remove a directory - with long filename support}

Function W32ShowDir:String;
{get the long name of the current directory}

Function GetShortFName(FName:String):String;
{get the short name of a long filename}

Function GetLongFName(Const FName:String):String;
{get the long name of a short filename}

Function GetFullFName(Const FName:String):String;
{get a file's full path name}

Function PathNameOnly(s:String):String;
{return the path only out of a filename}

Function FileNameOnly(s:String):String;
{strip the path out of a filename}

Procedure ConvertT32SearchRec(Var lr:WIN32_FIND_DATA;Var sR:T32SearchRec);
{convert a Win32_Find_Data record to a T32SearchRec record}

Function W32FindFirst(p:pchar;Const Attrs:longint;Var sR:T32SearchRec):longint;
{find a file - with long filename}

Function W32FindNext(Var sR:T32SearchRec):longbool;
{- ditto -}

Function LocateFiles(fSpec:pchar;Const Attrs:Longint;Var sR:T32SearchRec; CallBack:T32FileProc):Boolean;
{shell function to get filenames matching a spec}

Function GetEnv(lpName:String):String;
{get an environment variable}

Function SetEnv(lpName, lpValue:String):Longbool;
{set an environment variable}

Function W32Rewrite(Var fname:string):longint;
{create a new file - with long filename support}

Function W32Reset(fname:string):longint;
{ open a file - with long name support}

Function W32Close(handle:longint):longbool;
{close a file by its handle}

Function ExistFile(aName:PChar):Boolean;
{does the file exist?}

Function ExistDirectory(aName:PChar):Boolean;
{does the directory exist?}

Function ExistFileOrDirectory(aName:PChar):Boolean;
{does a file or directory exist?}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////// Win32 API functions /////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{//// version information ////}
  Function GetVersionEx(Var Info:OSVersionInfo):LongBool;
{ //// Processes ////}
  Function SetEnvironmentVariable(lpName, lpValue:pchar):Longbool;

  Function GetEnvironmentVariable(lpName, buffer:pchar;bufsize:longint):Longint;

  Function GlobalMemoryStatus(Var ms:MemoryStatus):longint;
  {
  Function GetFreeSpace(Flags:Longint):longint;
  }

  Function GetCurrentProcess:Longint;

  Function GetCurrentProcessId:Longint;

  Function GetCurrentThread:Longint;

  Function WaitForSingleObject(hObject,dwTimeout:longint):longint;

  Function CreateProcess(lpszImageName,lpszCommandLine:pchar;
                         lpsaProcess,lpsaThread:pointer;
                         fInheritHandles:longbool;
                         fdwCreate:longint;
                         lpvEnvironment:pointer;
                         lpszCurDir:pchar;
                         var lpsiStartInfo:tstartupinfo;
                         var lppiProcInfo:PROCESS_INFORMATION):longbool;

  Function ShellExecute(hwnd:longint;
           lpszOp,lpszFile,lpszParams,lpszDir:pchar;
           wShowCmd:longint):longint;

{ //// Files ////}
  Function FindFirstFile(lpszSearchFile:pchar;var lpffd:WIN32_FIND_DATA):longint;

  Function FindNextFile(hFindFile:longint;var lpffd:WIN32_FIND_DATA):longbool;

  Function FindClose(hFindFile:longint):Longbool;

  Function CloseHandle(hfile:longint):longbool;

  Function CreateFile(lpszName:pchar;fdwAccess,fdwShareMode:longint;lpsa:pointer;
                         fdwCreate,fdwAttrsAndFlags,hTemplateFile:longint):longint;

  Function CopyFile(source, dest:pchar;SkipExisting:longbool):longbool;

  Function MoveFile(lpszExisting,lpszNew:pchar):longbool;

  Function Deletefile(path:pchar):longbool;

  Function ReadFile(hFile:longint;var lpBuffer;nNumberOfBytesToRead:longint;
    var lpNumberOfBytesRead:longint;lpOverlapped:pointer):longbool;

  Function WriteFile(hFile:longint;var lpBuffer;nNumberOfBytesToWrite:longint;
    var lpNumberOfBytesWritten:longint;lpOverlapped:pointer):longbool;

  Function FlushFileBuffers(hfile:longint):longbool;

  Function SetFileAttributes(path:pchar;attr:longint):longbool;

  Function GetFileAttributes(path:pchar):longint;

  Function SetFilePointer(hFile,lDistanceToMove:longint;lpDistanceToMoveHigh:pointer;
            dwMoveMethod:longint):longint;

  Function SetFileTime(hFile:longint;lpftCreation,lpftLastAccess,lpftLastWrite:pfiletime):longbool;

  Function GetFileTime(hFile:longint;lpftCreation,lpftLastAccess,lpftLastWrite:pfiletime):longbool;

  Function FileTimeToSystemTime(var lpft:tFILETIME;var lpst:tsystemtime):longbool;

  Function FileTimeToLocalFileTime(var lpft,lpftlocal:tFILETIME):longbool;

  Function SystemTimeToFileTime(var lpst:tsystemtime;var lpft:tFILETIME):longbool;

  Function LocalFileTimeToFileTime(var lpftlocal,lpft:tFILETIME):longbool;

{//// Directories ///}
  Function GetCurrentDirectory(cchCurDir:longint;lpszCurDir:pchar):longint;

  Function SetCurrentDirectory(lpszCurDir:pchar):longbool;

  Function GetLastError:longint;

  Function CreateDirectory(path:pchar;security:pointer):longbool;

  Function RemoveDirectory(path:pchar):longbool;

{///// my own ////}
Function GetDriveType(path:pchar): byte;

Function GetFileSize(handle:longint;var hBit:longint):DWord;

Function GetLogicalDriveStrings (bufsize:longint;buffer:pchar):longint;

Function GetTempPath(bufsize:longint;buffer:pchar):longint;

Function SearchPath(spath,fname,fExt:pchar;bufsize:longint;
              buffer,justfname:pchar):longint;
{
Function GetFullPathName
(fname:pchar;bufsize:longint;buffer:Pchar;justfname:pchar):longint;
}
Function getFullPathName(FName:pChar;BufSize:LongInt;Buffer:pChar):Longint;

Function GetDC(ahwnd:longint):longint;

Function ReleaseDC(ahwnd,ahdc:Longint):longint;

Function PolyBezier(ahdc:longint;var points:tagPoint;count:Longint):Longint;

Function GetDesktopWindow:longint;

Function CreatePen(style,w,c:Longint):Longint;

Function SelectObject(ahdc,ahpen:longint):Longint;

Function DeleteObject(ahpen:Longint):Longint;

Function GetShortNameP(Fname:pChar):pChar;

Function GetShortPathName(Ind,ud:pChar;UdSize:LongInt):Longint;

Function GetExitCodeProcess(hProcess:LongInt;    {The process to test}
                             Var ExitCode:LongInt)  {The returned code}
                             :LongBool;

Function FindExecutable(fname,dir,aResult:Pchar):longint;
{/////////////////////////////////////////////////////////}
{file dialogs - doesn't work!!!!
Function GetOpenFileName(Var LpOfn:T32OpenFilename):LongBool;
}
{ Hooks }
{
Function CallNextHookEx(hhk, nCode, wParam, lParam:longint):LResult;
Function UnhookWindowsHookEx(hhk:HHook):Longbool;
Function SetWindowsHookEx(idHook:longint; hkprc:T32HookProc; hMod, dwThreadID:longint):HHook;
}
{///////////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////////}

implementation
uses
call32nt,WinProcs,{$ifdef ver80} Win_Dos, sysutils {$else}WinDos,Strings{$endif};

Var
Use32Bit:Boolean;
{True if we are using either NT or Win95, and ALL our 32-bit functions
initialised okay}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{//////// procedural variables for 32-bit functions ///////}
{/////////////////////////////////////////////////////////}
var
  (*
  W32GetOpenFileName:Function(Var LpOfn:T32OpenFilename;id:longint):LongBool;
  Id_W32GetOpenFileName:Longint;
  {doesn't work!}
  *)
  id_W32SetEnvironmentVariable:longint;
  W32SetEnvironmentVariable:Function(lpName, lpValue:pchar;id:longint):Longbool;

  id_W32GetEnvironmentVariable:longint;
  W32GetEnvironmentVariable:Function (lpName, buffer:pchar;bufsize, id:longint):Longint;

  W32FindFirstFile:
  function(lpszSearchFile:pchar;var lpffd:WIN32_FIND_DATA;id:longint):longint;

  W32FindNextFile:
  function(hFindFile:longint;var lpffd:WIN32_FIND_DATA;id:longint):longbool;

  W32FindClose:
  function(hFindFile:longint;id:longint):Longbool;

  W32FileTimeToSystemTime:function(var lpft:tFILETIME;var lpst:tsystemtime;id:longint):longbool;

  W32FileTimeToLocalFileTime:function(var lpft,lpftlocal:tFILETIME;id:longint):longbool;

  W32SystemTimeToFileTime:function(var lpst:tsystemtime;var lpft:tFILETIME;id:longint):longbool;
  W32LocalFileTimeToFileTime:function(var lpftlocal,lpft:tFILETIME;id:longint):longbool;
  W32GetCurrentDirectory:function(cchCurDir:longint;lpszCurDir:pchar;id:longint):longint;
  W32SetCurrentDirectory:function(lpszCurDir:pchar;id:longint):longbool;
  W32CreateFile:function(lpszName:pchar;fdwAccess,fdwShareMode:longint;lpsa:pointer;
                         fdwCreate,fdwAttrsAndFlags,hTemplateFile,id:longint):longint;
  W32MoveFile:function(lpszExisting,lpszNew:pchar;id:longint):longbool;
  W32GetLastError:function(id:longint):longint;
  W32CreateDirectory:function(path:pchar;security:pointer;id:longint):longbool;
  W32RemoveDirectory:function(path:pchar;id:longint):longbool;
  W32SetFileAttributes:function(path:pchar;attr,id:longint):longbool;
  W32GetFileAttributes:function(path:pchar;id:longint):longint;
  W32Deletefile:function(path:pchar;id:longint):longbool;
  W32SetFilePointer:function(hFile,lDistanceToMove:longint;lpDistanceToMoveHigh:pointer;
            dwMoveMethod,id:longint):longint;
  W32SetFileTime:function(hFile:longint;lpftCreation,lpftLastAccess,lpftLastWrite:pfiletime;
            id:longint):longbool;
  W32GetFileTime:function(hFile:longint;lpftCreation,lpftLastAccess,lpftLastWrite:pfiletime;
            id:longint):longbool;

  W32ReadFile:function(hFile:longint;var lpBuffer;nNumberOfBytesToRead:longint;
    var lpNumberOfBytesRead:longint;lpOverlapped:pointer;id:longint):longbool;
  W32WriteFile:function(hFile:longint;var lpBuffer;nNumberOfBytesToWrite:longint;
    var lpNumberOfBytesWritten:longint;lpOverlapped:pointer;id:longint):longbool;
  W32FlushFileBuffers:function(hfile,id:longint):longbool;

  W32ShellExecute:
  function(hwnd:longint;
           lpszOp,lpszFile,lpszParams,lpszDir:pchar;
           wShowCmd,id:longint):longint;

  W32CloseHandle:function(hfile,id:longint):longbool;

  W32WaitForSingleObject:function(hObject,dwTimeout,id:longint):longint;

  W32CreateProcess:
  function(lpszImageName,lpszCommandLine:pchar;
          lpsaProcess,lpsaThread:pointer;
          fInheritHandles:longbool;
          fdwCreate:longint;
          lpvEnvironment:pointer;
          lpszCurDir:pchar;
          var lpsiStartInfo:tstartupinfo;
          var lppiProcInfo:PROCESS_INFORMATION;
          id:longint):longbool;

  W32GetCurrentThread:function(id:longint):longint;

  W32GetCurrentProcess:function(id:longint):longint;

  W32GetCurrentProcessId:function(id:longint):longint;
{/////////////////////////////////////////////////////////}

Var
W32GetDriveType:Function(path:pchar; id:longint): byte;

W32CopyFile:Function(source, dest:pchar;SkipExisting:longbool;id:longint):longbool;

W32GetFileSize:Function(handle:longint;var hBit:longint;id:longint):DWord;

W32GetLogicalDriveStrings:
Function(bufsize:longint;buffer:pchar;id:longint):longint;

W32GetTempPath:Function(bufsize:longint;buffer:pchar;id:longint):longint;

W32SearchPath:
Function(searchpath,fname,fExt:pchar;bufsize:longint;buffer,justfname:pchar;id:longint):longint;


W32GetFullPathName:
Function(fname:pchar;bufsize:longint;buffer,justfname:pchar;id:longint):longint;


W32GetDC:function(hwnd,id:longint):longint;
W32ReleaseDC:function(hwnd,hdc,id:Longint):longint;
W32PolyBezier:function(hdc:longint;var points:tagPoint;count,id:Longint):Longint;
W32GetDesktopWindow:function(id:Longint):longint;
W32CreatePen:function(style,w,c,id:Longint):Longint;
W32SelectObject:function(hdc,hpen,id:longint):Longint;
W32DeleteObject:function(hpen,id:Longint):Longint;

W32GetShortPathName:Function(Ind,ud:pChar;UdSize,ID:LongInt):LongInt;
W32GetExitCodeProcess:Function(hProcess:LongInt;    {The process to test}
                                 Var ExitCode:LongInt;  {The returned code}
                                 ID:LongInt):LongBool;

W32FindExecutable:Function (fname,dir,aResult:Pchar;id:longint):longint;
W32GlobalMemoryStatus:function(Var ms:MemoryStatus;id:longint):longint;

Var
W32GetVersionEx:function(Var Info:OSVersionInfo;id:longint):longbool;
Id_W32GetVersionEx : longint;

{/////////////////////////////////////////////////////////}
{////////////longint variables for the procedural ones ///}
{/////////////////////////////////////////////////////////}
var
  {OldAttr,}
  id_W32FindExecutable,
  id_W32GetExitCodeProcess  : Longint;
  id_W32GetShortPathName    : LongInt;

  id_W32FindFirstFile,
  id_W32FindNextFile,
  id_W32FindClose,
  id_W32FileTimeToSystemTime,
  id_W32FileTimeToLocalFileTime,
  id_W32SystemTimeToFileTime,
  id_W32LocalFileTimeToFileTime,
  id_W32GetCurrentDirectory,
  id_W32SetCurrentDirectory,
  id_W32CreateFile,
  id_W32MoveFile,
  id_W32GetLastError,
  id_W32CreateDirectory,
  id_W32RemoveDirectory,
  id_W32SetFileAttributes,
  id_W32GetFileAttributes,
  id_W32Deletefile,
  id_W32SetFilePointer,
  id_W32setFileTime,
  id_W32GetFileTime,
  id_W32CloseHandle,
  id_W32ReadFile,
  id_W32WriteFile,
  id_W32FlushFileBuffers,
  id_W32ShellExecute,
  id_W32WaitForSingleObject,
  id_W32CreateProcess:longint;
  id_W32GetCurrentProcessId:Longint;
  id_W32GetCurrentProcess:Longint;
  id_W32GetCurrentThread:Longint;

  id_W32GlobalMemoryStatus,
  id_W32GetFreeSpace,
  id_W32GetFileSize,
  id_W32CopyFile,
  id_W32GetDriveType,
  id_W32GetLogicalDriveStrings,
  id_W32GetTempPath,
  id_W32SearchPath,
  id_W32GetFullPathName:longint;

  id_W32GetDesktopWindow,
  id_W32GetDC,
  id_W32ReleaseDC,
  id_W32PolyBezier,
  id_W32CreatePen,
  id_W32SelectObject,
  id_W32DeleteObject:longint;


{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Function ThisDrive:String;
{Returns the current drive: e.g., "C:", "D:"}
var
s:string;
Begin
   GetDir(0, s);
   ThisDrive:=Copy(s,1,2);
End;
{/////////////////////////////////////////////////////////}

{/////////////////////////////////////////////////////////}
Procedure ConvertT32SearchRec(Var lr:WIN32_FIND_DATA;Var sR:T32SearchRec);
{Converts a WIN32_FIND_DATA record to a T32SearchRec
record - used in my W32FindFirst and W32FindNext functions}
Var
  localtime:tFiletime;
  tdt:tsystemtime;

Begin
      With sR do begin
        FileTimeToLocalFileTime(lr.ftLastWriteTime,localtime);
        FileTimeToSystemTime(localtime,tdt);
        StrCopy(lName, lr.cFileName);
        StrCopy(Name, lr.cAlternateFileName);
        if Strlen(Name)=0 then StrCopy(Name,lName);

        With lDateTime do begin
            Year := Tdt.Year;
            Month:= Tdt.Month;
            Day  := Tdt.Day;
            Hour := Tdt.Hour;
            Min  := Tdt.Min;
            Sec  := Tdt.Sec;
        end;
        PackTime(lDateTime, sR.Time);
        Size := lr.nFileSizeLow;
        Attr := lr.dwFileAttributes;
      end;
End;
{/////////////////////////////////////////////////////////}
Function AttributesMatch(Const TheAttr, ToMatch:longint):longbool;
{Does the file attribute "ToMatch" match the attribute masks
in "TheAttr"? - this is used to match the attributes passed to
W32FindFirst()}
begin
   AttributesMatch:=false;
   If (Tomatch=faAnyFile)
   or ((TheAttr=0) and (ToMatch and faArchive<>0)){match 0 with archive}
   or (TheAttr and ToMatch <>0)
   then AttributesMatch:=true;
end;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Function FindLoop(Var sR:T32SearchRec):longbool;
{loop through files until one that matches the
attributes is found - this is used by W32FindFirst()
and W32FindNext()
}
Var
ismatch,ok:longbool;
lr:WIN32_FIND_DATA;

Begin
    FindLoop:=False;
    ismatch := false;
    While not ismatch do
    begin
      {no file found}
      ok := FindNextFile(sR.hHandle, lr);
      if not ok then begin
         FindLoop:=False;
         DosError:=2;
         exit;
      end;
      {attributes match}
      if  AttributesMatch(lr.dwFileAttributes, sR.hAttrib) then begin
          DosError:=0;
          ConvertT32SearchRec(lr, sR);
          FindLoop:=true;
          exit;
      end;
   end; {while not ismatch}
end;
{/////////////////////////////////////////////////////////}
Procedure TSearchRecToT32(var sR:T32SearchRec);
{convert a TSearchRec to a T32SearchRec}
begin
      With sR do begin
       {$ifdef Ver80}
        StrpCopy(sR.lName, sR.tSs.Name);
        StrpCopy(sR.Name, sR.tSs.Name);
       {$else}
        StrCopy(sR.lName, sR.tSs.Name);
        StrCopy(sR.Name, sR.tSs.Name);
       {$endif}
        sR.Time := sR.tSs.Time;
        sR.Size := sR.tSs.Size;
        sR.Attr := sR.tSs.Attr;
        UnPackTime(sR.tSs.Time,sR.lDateTime);
      end;
end;
{/////////////////////////////////////////////////////////}
Function W32FindFirst(p:pchar;Const Attrs:longint;Var sR:T32SearchRec):longint;
{find a file matching filespecs in "p", and attributes in "attrs"
 Return the result in a T32SearchRec record

 This can be used just like the FindFirst procedure in the WinDOS unit,
 even when not using 32-bit functionality

 e.g.,
 Var
 p:array[0..79] of char;
 sR:T32SearchRec;

 begin
    Strpcopy(p, 'C:\WIN95\*.*');
    W32FindFirst(p, faAnyFile, sR);
    While DosError=0 do begin
       Writeln('Short Name=',sr.Name);
       Writeln('Long  Name=',sr.lName);
       W32FindNext(sR);
    end;
 end.

 }
Var
handle:longint;
lr:WIN32_FIND_DATA;

Var
s1:string;
b:longbool;

Begin

   If Not Use32Bit then {if we are using 16-bits only - call WinDOS.FindFirst}
   begin
      {$ifdef Ver80}DosError := FindFirst(Strpas(p), Word(Attrs), sR.tSs);
      {$else}
      FindFirst(p, Word(Attrs), sR.tSs);
      {$endif}
      If DosError=0 then
      With sR do begin
      {$ifdef Ver80}
        StrpCopy(sR.lName, sR.tSs.Name);
        StrpCopy(sR.Name, sR.tSs.Name);
       {$else}
        StrCopy(sR.lName, sR.tSs.Name);
        StrCopy(sR.Name, sR.tSs.Name);
       {$endif}
        sR.Time := sR.tSs.Time;
        sR.Size := sR.tSs.Size;
        sR.Attr := sR.tSs.Attr;
        UnPackTime(sR.tSs.Time,sR.lDateTime);
      end;
      W32FindFirst:=DosError;
      exit;
   end;
   {}
   FillChar(sR, sizeof(sR), #0);
   s1:=StripChar(Strpas(p), '"');

   handle:=FindFirstFile(Str2PChar(s1), lr);
   if handle<>-1 then{success}
   begin
      sR.hHandle := Handle; {save handle}
      sR.hAttrib := Attrs;  {save attributes}

      if  AttributesMatch(lr.dwFileAttributes, Attrs) then
      begin
         ConvertT32SearchRec(lr, sR);
         DosError:=0;
      end
      else
      begin
         {else; attributes don't match}
         b := findloop(sr);
         if b then  {match found}
         begin
            DosError := 0;
         end {if b} else
         begin
            DosError:=2;
            FindClose(Handle);
            Handle := -1;
         end; {no match found}
       end; {attrs and oldattr<>0}
   end {handle<>-1}
   else begin
     DosError:=2;
   end;
   W32FindFirst:=handle;
End;
{/////////////////////////////////////////////////////////}
Function W32FindNext(Var sR:T32SearchRec):longbool;
{find the next file - after a call to W32FindFirst}
Var
b,ok:longbool;
lr:WIN32_FIND_DATA;
handle, Attr:Longint;

Begin

   If Not Use32Bit then begin {if we are using 16-bits only - call WinDOS.FindNext}
      {$ifdef Ver80}DosError := {$endif}FindNext(sR.Tss);
      If DosError=0 then
      With sR do begin
      {$ifdef Ver80}
        StrpCopy(sR.lName, sR.tSs.Name);
        StrpCopy(sR.Name, sR.tSs.Name);
      {$else}
        StrCopy(sR.lName, sR.tSs.Name);
        StrCopy(sR.Name, sR.tSs.Name);
      {$endif}
        sR.Time := sR.tSs.Time;
        sR.Size := sR.tSs.Size;
        sR.Attr := sR.tSs.Attr;
        UnPackTime(sR.tSs.Time,sR.lDateTime);
      end;
      W32FindNext:=DosError=0;
      exit;
   end;

    W32FindNext:=false;
    handle := sR.hHandle;
    Attr   := sR.hAttrib;

    ok := FindNextFile(Handle, lr);
    If not ok then begin
       DosError:=2;        {no match; return not found code}
       FindClose(Handle);  {dispose of the file handle}
       exit;
    end;

    if  AttributesMatch(lr.dwFileAttributes, Attr) then begin
       ConvertT32SearchRec(lr, sR);
       DosError:=0;
       W32FindNext:=true;
       exit;
    end;

    {attrs don't match - search on}
    b := findloop(sr);
    if b then  {match found}
    begin
      DosError := 0;
      W32FindNext:=true;
      exit;
    end {if b} else
    begin
      DosError:=2;
      FindClose(Handle);
    end; {no match found}
End;
{/////////////////////////////////////////////////////////}
Function LocateFiles(fSpec:pchar;Const Attrs:Longint;Var sR:T32SearchRec;
CallBack:T32FileProc):Boolean;
{ sample shell function for searching for files;
  fills the T32SearchRec structure;
  Calls the T32FileProc function if <> Nil
}
Var
handle:longint;

Begin
  LocateFiles:=False;
  If Not Use32Bit then Exit;
  handle:=W32FindFirst(fSpec, faAnyFile, sR);
  While DosError=0 do
  begin
    if @CallBack<>Nil then CallBack(sR);
    W32FindNext(sR);
  end;
End;

{/////////////////////////////////////////////////////////}
Function SetEnvironmentVariable(lpName, lpValue:pchar):Longbool;
Begin
   SetEnvironmentVariable :=
   W32SetEnvironmentVariable(lpName, lpValue,
   id_W32SetEnvironmentVariable);
End;

{/////////////////////////////////////////////////////////}
Function GetEnvironmentVariable(lpName, buffer:pchar;bufsize:longint):Longint;
Begin
   If id_W32GetEnvironmentVariable>=0
   then GetEnvironmentVariable :=
        W32GetEnvironmentVariable(lpName, buffer, bufsize,
        id_W32GetEnvironmentVariable)
   else GetEnvironmentVariable := -1;
End;
{/////////////////////////////////////////////////////////}
Function SetEnv(lpName, lpValue:String):Longbool;
Begin
  SetEnv := SetEnvironmentVariable(Str2PChar(lpname), Str2PChar(lpvalue));
End;
{/////////////////////////////////////////////////////////}
Function GetEnv(lpName:String):String;
Var
p:pchar;
Begin
   GetEnv := '';
   if lpName='' then exit;

   If not Use32Bit then begin
      {$ifdef Ver80}
      GetEnv := GetEnvVar(lpName);
      {$else}
      p := GetEnvVar(Str2Pchar(lpName));
      if p <> Nil then GetEnv := StrPas(p);
      {$endif}
      exit;
   end;

   Getmem(p,262);
   If GetEnvironmentVariable(Str2Pchar(lpName), p, 260) > 0
   then GetEnv := Strpas(p);
   Freemem(p, 262);
End;
{/////////////////////////////////////////////////////////}
Function CloseHandle(hfile:longint):longbool;
Begin
     CloseHandle := W32CloseHandle(hFile, id_W32CloseHandle);
End;

{/////////////////////////////////////////////////////////}
Function WaitForSingleObject(hObject,dwTimeout:longint):longint;
Begin
      WaitForSingleObject := W32WaitForSingleObject(hObject, dwTimeOut,
      id_W32WaitForSingleObject);
End;

{/////////////////////////////////////////////////////////}
  Function CreateProcess(lpszImageName,lpszCommandLine:pchar;
          lpsaProcess,lpsaThread:pointer;
          fInheritHandles:longbool;
          fdwCreate:longint;
          lpvEnvironment:pointer;
          lpszCurDir:pchar;
          var lpsiStartInfo:tstartupinfo;
          var lppiProcInfo:PROCESS_INFORMATION):longbool;
  Begin
          CreateProcess := W32CreateProcess(
          lpszImageName,
          lpszCommandLine,
          lpsaProcess,
          lpsaThread,
          fInheritHandles,
          fdwCreate,
          lpvEnvironment,
          lpszCurDir,
          lpsiStartInfo,
          lppiProcInfo,
          id_W32CreateProcess);
  End;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
  Function FindFirstFile(lpszSearchFile:pchar;var lpffd:WIN32_FIND_DATA):longint;
  Begin
     FindFirstFile := W32FindFirstFile
     (lpszSearchFile, lpffd, id_W32FindFirstFile);
  End;
{/////////////////////////////////////////////////////////}
  Function FindNextFile(hFindFile:longint;var lpffd:WIN32_FIND_DATA):longbool;
  Begin
     FindNextFile := W32FindNextFile(hFindFile, lpffd, id_W32FindNextFile);
  End;
{/////////////////////////////////////////////////////////}
  Function FindClose(hFindFile:longint):Longbool;
  Begin
    FindClose := W32FindClose(hFindFile, id_W32FindClose);
  End;
{/////////////////////////////////////////////////////////}
  Function GetCurrentProcess:Longint;
  Begin
      GetCurrentProcess := W32GetCurrentProcess(id_W32GetCurrentProcess);
  End;
{/////////////////////////////////////////////////////////}
  Function GetCurrentProcessId:Longint;
  Begin
      GetCurrentProcessId := W32GetCurrentProcessId(id_W32GetCurrentProcessId);
  End;
{/////////////////////////////////////////////////////////}
  Function GetCurrentThread:Longint;
  Begin
      GetCurrentThread := W32GetCurrentThread(id_W32GetCurrentThread);
  End;
{/////////////////////////////////////////////////////////}
  Function FileTimeToSystemTime(var lpft:tFILETIME;var lpst:tsystemtime):longbool;
  Begin
      FileTimeToSystemTime :=
      W32FileTimeToSystemTime(lpft, lpst, id_W32FileTimeToSystemTime);
  End;
{/////////////////////////////////////////////////////////}
  Function FileTimeToLocalFileTime(var lpft,lpftlocal:tFILETIME):longbool;
  Begin
    FileTimeToLocalFileTime:=
    W32FileTimeToLocalFileTime(lpft, lpftlocal, id_W32FileTimeToLocalFileTime);
  End;
{/////////////////////////////////////////////////////////}
  Function SystemTimeToFileTime(var lpst:tsystemtime;var lpft:tFILETIME):longbool;
  Begin
       SystemTimeToFileTime := W32SystemTimeToFileTime
       (lpst,lpft,id_W32SystemTimeToFileTime);
  End;
{/////////////////////////////////////////////////////////}
  Function LocalFileTimeToFileTime(var lpftlocal,lpft:tFILETIME):longbool;
  Begin
     LocalFileTimeToFileTime:= W32LocalFileTimeToFileTime
     (lpftlocal,lpft,id_W32LocalFileTimeToFileTime);
  End;
{/////////////////////////////////////////////////////////}
  Function GetCurrentDirectory(cchCurDir:longint;lpszCurDir:pchar):longint;
  Begin
       GetCurrentDirectory := W32GetCurrentDirectory
       (cchCurDir, lpszCurDir,id_W32GetCurrentDirectory);
  End;
{/////////////////////////////////////////////////////////}
  Function SetCurrentDirectory(lpszCurDir:pchar):longbool;
  Begin
      SetCurrentDirectory := W32SetCurrentDirectory
       (lpszCurDir,id_W32SetCurrentDirectory);
  End;
{/////////////////////////////////////////////////////////}
  Function CreateFile
  (lpszName:pchar;fdwAccess,fdwShareMode:longint;lpsa:pointer;
  fdwCreate,fdwAttrsAndFlags,hTemplateFile:longint):longint;
  Begin
       CreateFile := W32CreateFile
       (lpszName,fdwAccess,fdwShareMode,lpsa,
        fdwCreate,fdwAttrsAndFlags,hTemplateFile,id_W32CreateFile);
  End;
{/////////////////////////////////////////////////////////}
  Function MoveFile(lpszExisting,lpszNew:pchar):longbool;
  Begin
       MoveFile := W32MoveFile
       (lpszExisting,lpszNew,id_W32MoveFile);
  End;
{/////////////////////////////////////////////////////////}
  Function GetLastError:longint;
  Begin
       GetLastError := W32GetLastError
       (id_W32GetLastError);
  End;
{/////////////////////////////////////////////////////////}
  Function CreateDirectory(path:pchar;security:pointer):longbool;
  Begin
       CreateDirectory := W32CreateDirectory
       (path,security ,id_W32CreateDirectory);
  End;
{/////////////////////////////////////////////////////////}
  Function RemoveDirectory(path:pchar):longbool;
  Begin
       RemoveDirectory := W32RemoveDirectory
       (path ,id_W32RemoveDirectory);
  End;
{/////////////////////////////////////////////////////////}
  Function SetFileAttributes(path:pchar;attr:longint):longbool;
  Begin
       SetFileAttributes := W32SetFileAttributes
       (path,attr ,id_W32SetFileAttributes);
  End;
{/////////////////////////////////////////////////////////}
  Function GetFileAttributes(path:pchar):longint;
  Begin
  GetFileAttributes :=$FFFFFFFF;
  If id_W32GetFileAttributes>=0 then
       GetFileAttributes:= W32GetFileAttributes
       (path,id_W32GetFileAttributes);
  End;
{/////////////////////////////////////////////////////////}
  Function Deletefile(path:pchar):longbool;
  Begin
       SetFileAttributes(path, File_Attribute_Archive);
       Deletefile:= W32Deletefile
       (path ,id_W32Deletefile);
  End;
{/////////////////////////////////////////////////////////}
  Function SetFilePointer
  (hFile,lDistanceToMove:longint;lpDistanceToMoveHigh:pointer;
  dwMoveMethod:longint):longint;
  Begin
       SetFilePointer:= W32SetFilePointer
       (hFile,lDistanceToMove,lpDistanceToMoveHigh,
        dwMoveMethod,id_W32SetFilePointer);
  End;
{/////////////////////////////////////////////////////////}
  Function SetFileTime
  (hFile:longint;lpftCreation,lpftLastAccess,lpftLastWrite:pfiletime):longbool;
  Begin
       SetFileTime:= W32SetFileTime
       (hFile,lpftCreation,lpftLastAccess,lpftLastWrite,id_W32SetFileTime);
  End;
{/////////////////////////////////////////////////////////}
  Function GetFileTime
  (hFile:longint;lpftCreation,lpftLastAccess,lpftLastWrite:pfiletime):longbool;
  Begin
       GetFileTime:= W32GetFileTime
       (hFile,lpftCreation,lpftLastAccess,lpftLastWrite,id_W32GetFileTime);
  End;
{/////////////////////////////////////////////////////////}
  Function ReadFile(hFile:longint;var lpBuffer;nNumberOfBytesToRead:longint;
    var lpNumberOfBytesRead:longint;lpOverlapped:pointer):longbool;
  Begin
       ReadFile:= W32ReadFile
       (hFile,lpBuffer,nNumberOfBytesToRead,lpNumberOfBytesRead,
       lpOverlapped,id_W32ReadFile);
  End;
{/////////////////////////////////////////////////////////}
  Function WriteFile(hFile:longint;var lpBuffer;nNumberOfBytesToWrite:longint;
    var lpNumberOfBytesWritten:longint;lpOverlapped:pointer):longbool;
  Begin
       WriteFile := W32WriteFile
       (hFile,lpBuffer,nNumberOfBytesToWrite,lpNumberOfBytesWritten,
       lpOverlapped,id_W32WriteFile);
  End;
{/////////////////////////////////////////////////////////}
  Function FlushFileBuffers(hfile:longint):longbool;
  Begin
       FlushFileBuffers := W32FlushFileBuffers
       (hfile,id_W32FlushFileBuffers);
  End;
{/////////////////////////////////////////////////////////}
Function ShellExecute(hwnd:longint;lpszOp,lpszFile,lpszParams,lpszDir:pchar;
wShowCmd:longint):longint;
Begin
 ShellExecute:= W32ShellExecute(hwnd, lpszOp,lpszFile,lpszParams,lpszDir,
 wShowCmd,id_W32ShellExecute);
End;
{////////////////////////////////////////////////////////////////////}
Function GetDriveType(path:pchar): byte;
Begin
    GetDriveType:= W32GetDriveType(path ,id_W32GetDriveType);
End;
{////////////////////////////////////////////////////////////////////}
Function CopyFile(source, dest:pchar;SkipExisting:longbool):longbool;
Begin
    CopyFile:= W32CopyFile(source,dest,SkipExisting,id_W32CopyFile);
End;
{////////////////////////////////////////////////////////////////////}
Function GetFileSize(handle:longint;var hBit:longint):DWord;
Begin
   GetFileSize := W32GetFileSize(handle,hbit,id_W32GetFileSize);
End;
{////////////////////////////////////////////////////////////////////}
Function GetLogicalDriveStrings (bufsize:longint;buffer:pchar):longint;
Begin
    GetLogicalDriveStrings:= W32GetLogicalDriveStrings
    (bufsize,buffer ,id_W32GetLogicalDriveStrings);
End;
{////////////////////////////////////////////////////////////////////}
Function GetTempPath(bufsize:longint;buffer:pchar):longint;
Begin
   GetTempPath := W32GetTempPath(bufsize,buffer,id_W32GetTempPath);
End;
{////////////////////////////////////////////////////////////////////}
Function SearchPath(spath,fname,fExt:pchar;bufsize:longint;
              buffer,justfname:pchar):longint;
Begin
   SearchPath := W32SearchPath(spath,fname,fExt,bufsize,
   buffer,justfname,id_W32SearchPath);
End;
{////////////////////////////////////////////////////////////////////}
Function GetDC(ahwnd:longint):longint;
Begin
  GetDC:= W32GetDC (ahwnd ,id_W32GetDC);
End;
{/////////////////////////////////////////////////////////}
Function ReleaseDC(ahwnd,ahdc:Longint):longint;
Begin
  ReleaseDC:= W32ReleaseDC (ahwnd,ahdc ,id_W32ReleaseDC);
End;
{/////////////////////////////////////////////////////////}
Function PolyBezier(ahdc:longint;var points:tagPoint;count:Longint):Longint;
Begin
  PolyBezier:= W32PolyBezier
  (ahdc,points,count ,id_W32PolyBezier);
End;
{/////////////////////////////////////////////////////////}
Function GetDesktopWindow:longint;
Begin
  GetDesktopWindow:= W32GetDesktopWindow (id_W32GetDesktopWindow);
End;
{/////////////////////////////////////////////////////////}
Function CreatePen(style,w,c:Longint):Longint;
Begin
 CreatePen := W32CreatePen (style,w,c,id_W32CreatePen);
End;
{/////////////////////////////////////////////////////////}
Function SelectObject(ahdc,ahpen:longint):Longint;
Begin
  SelectObject:= W32SelectObject (ahdc,ahpen ,id_W32SelectObject);
End;
{/////////////////////////////////////////////////////////}
Function DeleteObject(ahpen:Longint):Longint;
Begin
  DeleteObject:= W32DeleteObject (ahpen ,id_W32DeleteObject);
End;
{/////////////////////////////////////////////////////////}
Function GetShortPathName(Ind,ud:pChar;UdSize:LongInt):Longint;
Begin
  GetShortPathName:=Strlen(Ind);
  If ID_W32getShortPathName>=0 then Begin
    getShortPathName:=W32GetShortPathName(Ind,ud,UdSize,ID_W32GetShortPathName);
  End Else StrlCopy(Ud,ind,UdSize);
End;
{/////////////////////////////////////////////////////////}
Function GetShortNameP(Fname:pChar):pChar;
Var
  Temp : pChar;
Begin
  getMem(Temp,512);
  If GetShortPathName(FName,Temp,511)=0 then StrLCopy(Temp,FName,511);
  StrCopy(FName,Temp);
  FreeMem(Temp,512);
  getShortNameP:=FName;
End;
{/////////////////////////////////////////////////////////}
Function  GetExitCodeProcess(hProcess:LongInt;    {The process to test}
                             Var ExitCode:LongInt)  {The returned code}
                             :LongBool;
Begin
  GetExitCodeProcess:=W32GetExitCodeProcess
  (hProcess, ExitCode,id_W32GetExitCodeProcess);
End;
{/////////////////////////////////////////////////////////}
Function FindExecutable(fname,dir,aResult:Pchar):longint;
Begin
   FindExecutable := W32FindExecutable(fname,dir,aResult,id_W32FindExecutable);
End;
{/////////////////////////////////////////////////////////}
function GlobalMemoryStatus(Var ms:MemoryStatus):longint;
Begin
 GlobalMemoryStatus := W32GlobalMemoryStatus(Ms, id_W32GlobalMemoryStatus);
End;
{/////////////////////////////////////////////////////////}
{
Function GetOpenFileName(Var LpOfn:T32OpenFilename):LongBool;
Begin
 GetOpenFileName:=W32GetOpenFileName(LpOFN, Id_W32GetOpenFileName);
End;
}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
(*
hooks - not complete !!!! - had some major problems
Var
W32CallNextHookEx:function(hhk, nCode, wParam, lParam, id:longint):LResult;
W32UnhookWindowsHookEx:function(hhk:HHook;id:longint):Longbool;
W32SetWindowsHookEx:Function (idHook:longint; Var hkprc:T32HookProc; hMod, dwThreadID,id:longint):HHook;

Var
Id_W32CallNextHookEx:longint;
id_W32UnhookWindowsHookEx:longint;
Id_W32SetWindowsHookEx:longint;

{///////////////////////////////////////////////////////////////}
Function CallNextHookEx(hhk, nCode, wParam, lParam:longint):LResult;
Begin
   If Not Use32Bit then begin
   end else
   CallNextHookEx :=
   W32CallNextHookEx(hhk, nCode, wParam, lParam, Id_W32CallNextHookEx);
End;
{///////////////////////////////////////////////////////////////}
Function UnhookWindowsHookEx(hhk:HHook):Longbool;
Begin
   If Not Use32Bit then begin
   end else
    UnhookWindowsHookEx:= W32UnhookWindowsHookEx(hhk, Id_W32UnhookWindowsHookEx);
End;
{///////////////////////////////////////////////////////////////}
Function SetWindowsHookEx(idHook:longint; hkprc:T32HookProc; hMod, dwThreadID:longint):HHook;
Begin
   If Not Use32Bit then begin
   end else
   SetWindowsHookEx :=
   W32SetWindowsHookEx(idHook, hkprc, hMod, dwThreadID,Id_W32SetWindowsHookEx);
End;
*)
{///////////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////////}
Function ExistDirectory(aName:PChar):Boolean;
Var
  Temp : LongInt;
  Temp1 : File;
  Temp2 : Word;
Begin
  If Use32Bit then begin
    temp:=GetFileAttributes(aName);
    ExistDirectory:=temp=$00000010;
  End Else Begin
    Assign(Temp1,aName);
    GetfAttr(Temp1,Temp2);
    ExistDirectory:=
    ((Temp2 and faVolumeID)=0) and
    ((Temp2 and faDirectory)<>0) and (DosError=0);
  End;
End;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Function ExistFile(aName:PChar):Boolean;
Var
  Temp : LongInt;
  Temp1 : File;
  Temp2 : Word;
Begin
  If Use32Bit then begin
    temp:=GetFileAttributes(aName);
    ExistFile:= (temp<>$FFFFFFFF) and (temp<>$00000010);
  End Else Begin
    Assign(Temp1,aName);
    GetfAttr(Temp1,Temp2);
    ExistFile:=
    ((Temp2 and faVolumeID)=0) and
    ((Temp2 and faDirectory)=0) and (DosError=0);
  End;
End;
{/////////////////////////////////////////////////////////}
Function ExistFileOrDirectory(aName:PChar):Boolean;
Var
  Temp : LongInt;
  Temp1 : File;
  Temp2 : Word;
Begin
  If Use32Bit then begin
    temp:=GetFileAttributes(aName);
    ExistFileOrDirectory:=temp<>$FFFFFFFF;
  End Else Begin
    Assign(Temp1,aName);
    GetfAttr(Temp1,Temp2);
    ExistFileOrDirectory:=((Temp2 and faVolumeId)=0) and (DosError=0);
  End;
End;
{/////////////////////////////////////////////////////////}
Function IsUNCP(aName:pChar):Boolean;
Begin
  IsUNCP:=((Strlen(aName)>4) and (aName[0]='\') and (aName[1]='\')) and
    (StrScan(aName+3,'\')<>Nil);
End;
{/////////////////////////////////////////////////////////}
Function getFullPathName(FName:pChar;BufSize:LongInt;Buffer:pChar):Longint;
Var
  Tal : pChar;
  Save: pChar;
Begin
  If id_W32getFullPathName>=0 then begin
    getmem(tal, 260);
    getFullPathName:=
    W32getFullPathName(FName,BufSize,Buffer,Tal,id_W32GetFullPathName);
    freemem(tal, 260);
  end
  Else begin
    If IsUNCP(FName) Then begin
      Tal:=StrScan(StrScan(StrScan(StrScan(FName,'\')+1,'\')+1,'\')+1,'\');
      If Tal<>Nil Then begin
        GetMem(Save,260);
        FileExpand(Save,Tal);
        Tal[0]:=#0;
        StrCopy(Buffer,FName);
        Tal[0]:='\';
        StrCat(Buffer,Save+2);
        FreeMem(save,260);
      End Else
        FileExpand(Buffer,FName);
    End Else
      FileExpand(Buffer,FName);
    getFullPathName:=Strlen(Buffer);
  End;
End;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
function W32WinExec(p:pchar;mode:longint):longint;
{A Win32 WinExec function - calls CreateProcess -
seems to work okay}
Var
Code,
i,j:longint;
ts:TStartupinfo;
pi:process_information;
p2,p3:pchar;
b    :longbool;

begin
    W32WinExec := 0;
    If Not Use32Bit then begin
       W32WinExec:=WinProcs.WinExec(p,mode);
       Exit;
    end;

    FillChar(ts, Sizeof(ts), 0);
    With ts do begin
      cb := sizeof(ts);
     wShowWindow := mode;
    end;


   getmem(p3,512);
   {
   getmem(p2,512);
   Code := FindExecutable(p, '', p2);
   If code > 32 then begin
    Strcopy(p3, p2);
    Strcat(p3, ' ');
    Strcat(p3, p);
   end
   else Strcopy(p3, p);
   freemem(p2, 512);
   }
   Strcopy(p3, p);

   b:= CreateProcess
   (Nil, p3, nil, Nil, false, NORMAL_PRIORITY_CLASS, Nil, Nil, ts, pi);

   freemem(p3, 512);

   If b = false then exit;
   i := pi.hProcess;
   W32WinExec := pi.dwProcessId;
   CloseHandle(i);
end;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Procedure InitialiseWin32;far;
{initialise all the Win32 functions}
Var Os:^OsVersionInfo;
Begin

  {first assign the functions to Call32 - in Call32NT.PAS}
  @W32FindFirstFile:=@Call32;
  @W32FindNextFile:=@Call32;
  @W32FindClose:=@Call32;
  @W32FileTimeToSystemTime:=@Call32;
  @W32FileTimeToLocalFileTime:=@Call32;
  @W32SystemTimeToFileTime:=@Call32;
  @W32LocalFileTimeToFileTime:=@Call32;
  @W32GetCurrentDirectory:=@Call32;
  @W32SetCurrentDirectory:=@Call32;
  @W32CreateFile:=@Call32;
  @W32MoveFile:=@Call32;
  @W32GetLastError:=@Call32;
  @W32CreateDirectory:=@Call32;
  @W32RemoveDirectory:=@Call32;
  @W32SetFileAttributes:=@Call32;
  @W32GetFileAttributes:=@Call32;
  @W32Deletefile:=@Call32;
  @W32SetFilePointer:=@Call32;
  @W32setFileTime:=@Call32;
  @W32GetFileTime:=@Call32;
  @W32CloseHandle:=@Call32;
  @W32ReadFile:=@Call32;
  @W32WriteFile:=@Call32;
  @W32FlushFileBuffers:=@Call32;
  @W32ShellExecute:=@Call32;
  @W32WaitForSingleObject:=@Call32;
  @W32CreateProcess:=@Call32;
  @W32GetCurrentThread:=@Call32;
  @W32GetCurrentProcess:=@Call32;
  @W32GetCurrentProcessId:=@Call32;

  {}
  @W32GetFileSize:=@Call32;
  @W32CopyFile:=@Call32;
  @W32GetDriveType:=@Call32;
  @W32GetLogicalDriveStrings:=@Call32;
  @W32GetTempPath:=@Call32;
  @W32SearchPath:=@Call32;
  @W32GetFullPathName:=@Call32;
  @W32FindExecutable:=@Call32;
  @W32GlobalMemoryStatus:=@Call32;
  {}
  @W32GetDC:=@Call32;
  @W32ReleaseDC:=@Call32;
  @W32PolyBezier:=@Call32;
  @W32GetDesktopWindow:=@Call32;
  @W32CreatePen:=@Call32;
  @W32SelectObject:=@Call32;
  @W32DeleteObject:=@Call32;
  @W32GetExitCodeProcess:=@Call32;
  @W32GetShortPathName:=@Call32;

  @W32SetEnvironmentVariable:=@Call32;
  @W32GetEnvironmentVariable:=@Call32;

  {Then get the win32 functions from their DLLs}
  {First:  The name of the original win32 function: CASE SENSITIVE!!!!!}
  {Second: The name of the 32 bit module where the function is located}
  {Third:  A string describing all parameters. p=pointer, i=longint, w=Windows handle}
  id_W32SetEnvironmentVariable:=Declare32('SetEnvironmentVariable', 'kernel32', 'pp');
  id_W32GetEnvironmentVariable:=Declare32('GetEnvironmentVariable', 'kernel32', 'ppi');

  id_W32GetDriveType:=Declare32('GetDriveType', 'kernel32', 'p');
  id_W32GetFileSize:=Declare32('GetFileSize', 'kernel32', 'ip');

  id_W32CopyFile:=Declare32('CopyFile', 'kernel32', 'ppi');
  id_W32GetLogicalDriveStrings:=Declare32('GetLogicalDriveStrings', 'kernel32', 'ip');
  id_W32GlobalMemoryStatus:=Declare32('GlobalMemoryStatus', 'kernel32', 'p');

  id_W32GetTempPath:=Declare32('GetTempPath', 'kernel32', 'ip');
  id_W32SearchPath:=Declare32('SearchPath', 'kernel32', 'pppipp');
  id_W32GetFullPathName:=Declare32('GetFullPathName', 'kernel32', 'pipp');
  id_W32FindExecutable:=Declare32('FindExecutable', 'shell32', 'ppp');

  id_W32FindFirstFile:=Declare32('FindFirstFile', 'kernel32', 'pp');
  id_W32FindNextFile:=Declare32('FindNextFile', 'kernel32', 'ip');
  id_W32FindClose:=Declare32('FindClose', 'kernel32', 'i');
  id_W32FileTimeToSystemTime:=Declare32('FileTimeToSystemTime', 'kernel32', 'pp');
  id_W32FileTimeToLocalFileTime:=Declare32('FileTimeToLocalFileTime', 'kernel32', 'pp');
  id_W32SystemTimeToFileTime:=Declare32('SystemTimeToFileTime','kernel32','pp');
  id_W32LocalFileTimeToFileTime:=Declare32('LocalFileTimeToFileTime','kernel32','pp');
  id_W32GetCurrentDirectory:=Declare32('GetCurrentDirectory','kernel32','ip');
  id_W32SetCurrentDirectory:=Declare32('SetCurrentDirectory','kernel32','p');
  id_W32CreateFile:=Declare32('CreateFile','kernel32','piipiii');
  id_W32MoveFile:=Declare32('MoveFile','kernel32','pp');
  id_W32GetLastError:=Declare32('GetLastError','kernel32','');
  id_W32CreateDirectory:=Declare32('CreateDirectory','kernel32','pp');
  id_W32RemoveDirectory:=Declare32('RemoveDirectory','kernel32','p');
  id_W32SetFileAttributes:=Declare32('SetFileAttributes','kernel32','pi');
  id_W32GetFileAttributes:=Declare32('GetFileAttributes','kernel32','p');
  id_W32Deletefile:=Declare32('DeleteFile','kernel32','p');
  id_W32SetFilePointer:=Declare32('SetFilePointer','kernel32','iipi');
  id_W32setFileTime:=Declare32('SetFileTime','kernel32','ippp');
  id_W32GetFileTime:=Declare32('GetFileTime','kernel32','ippp');
  id_W32ReadFile:=Declare32('ReadFile','kernel32','ipipp');
  id_W32WriteFile:=Declare32('WriteFile','kernel32','ipipp');
  id_W32FlushFileBuffers:=Declare32('FlushFileBuffers','kernel32','i');

  {process functions }
  id_W32GetCurrentThread:=Declare32('GetCurrentThread','kernel32','i');
  id_W32GetCurrentProcess:=Declare32('GetCurrentProcess','kernel32','i');
  id_W32GetCurrentProcessId:=Declare32('GetCurrentProcessId','kernel32','i');
  id_W32ShellExecute:=Declare32('ShellExecute','shell32','wppppi');
  id_W32CreateProcess:=Declare32('CreateProcess','kernel32','ppppiipppp');
  id_W32WaitForSingleObject:=Declare32('WaitForSingleObject','kernel32','ii');
  id_W32CloseHandle:=Declare32('CloseHandle','kernel32','i');

  id_W32GetDC:=Declare32('GetDC', 'user32', 'w');
  id_W32ReleaseDC:=Declare32('ReleaseDC', 'user32', 'wi');
  id_W32PolyBezier:=Declare32('PolyBezier', 'gdi32', 'ipi');
  id_W32CreatePen:=Declare32('CreatePen', 'gdi32', 'iii');
  id_W32SelectObject:=Declare32('SelectObject', 'gdi32', 'ii');
  id_W32DeleteObject:=Declare32('DeleteObject', 'gdi32', 'i');

  id_W32GetExitCodeProcess:=Declare32('GetExitCodeProcess','kernel32','ip');
  id_W32GetShortPathName:= Declare32('GetShortPathName', 'Kernel32','ppi');

   {version information}
   @W32GetVersionEx:=@Call32;
   Id_W32GetVersionEx:=Declare32('GetVersionEx','kernel32','p');

  (*
  {hooks; not fully functional }

  @W32CallNextHookEx:=@Call32;
  @W32UnhookWindowsHookEx:=@Call32;
  @W32SetWindowsHookEx:=@Call32;
  Id_W32CallNextHookEx:=Declare32('CallNextHookEx', 'user32','iiii');
  id_W32UnhookWindowsHookEx:=Declare32('UnhookWindowsHookEx', 'user32','i');
  Id_W32SetWindowsHookEx:=Declare32('SetWindowsHookEx', 'user32','ipii');

  {file dialogs; doesn't work!}
   @W32GetOpenFileName:=@Call32;
   Id_W32GetOpenFileName:=Declare32('GetOpenFileName','comdlg32','p');
   *)

   Use32Bit := Call32NTError=False; {any error at all, and we disable all 32-bits}
   IsWindowsNT := IsWinNT;
   If ( (Use32Bit=True) and (IsWindowsNT=False) )
   then begin
      New(Os);
      With Os^ do begin
         dwOSVersionInfoSize := Sizeof(OsVersionInfo);
         GetVersionEx(Os^);
         IsWindows98 := (dwMajorVersion=4) and (dwMinorVersion=10);
         IsWindows95 := NOT IsWindows98;
      end;
      Dispose(Os);
   end;
End{InitialiseWin32};
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Function IsWinNT : Boolean;
{Is this Windows NT?}
const
WF_WINNT = $4000;
var
l:longint;
Begin
  l := WinProcs.getWinFlags;
  IsWinNT :=  l and WF_WinNT <> 0;
End;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Function W32FullPathName(s:string):String;
{return a fully qualified path for a file/directory
which you know to exist}
Var
s1:^string;
Begin
    W32FullPathName:=s;
    If Not Use32Bit then exit;

    new(s1);
    s1^:=PathNameOnly(s);
    if s1^>'' then begin
      If W32IsDirectory(s1^) then begin
         s:=addbackslash(s1^)+FilenameOnly(s);
      end;
    end else s:= addbackslash(W32ShowDir)+s;

    W32FullPathName:=GetlongFname(s);
    dispose(s1);
End;
{/////////////////////////////////////////////////////////}
Function W32MkDir(s:String): longint;
{Make a directory - with long filename support
 Use Ioresult as normal - if successful, IoResult will be 0
 if not successful, I implement a kludge to force an IO error
 so that IoResult <> 0

 e.g.,
   s := 'D:\This is a Long.Directory Name';
   W32MkDir(s);
   If IoResult <> 0 then Writeln('Error')
   else s:=GetShortFName(s);
}
Var
i:integer;
p:array[0..260] of char;
b:longbool;

Begin
    W32MkDir := -1;
    s:=StripChar(s,'"');

    {path starts with "\"}
    if (s[1]='\') then if Not IsUNC(s) then begin
       s:=ThisDrive+s;
    end;


    If Use32Bit then
    begin
      Strpcopy(p, W32FullPathName(s));
      b := CreateDirectory(p, Nil);
      W32MkDir := GetLastError;
      If b = TRUE then
      begin
        W32MkDir := 0;
        i := ioresult; {clear ioresult}
      end Else begin
         {force an io error so that ioresult<>0}
         s:='Z:\Z\!$.'; {bad directory - this is the worst I can come up with!}
         System.ChDir(s);
      end;
    End {Use32Bit}
    else begin
      System.MkDir(s);
    End;
End;
{/////////////////////////////////////////////////////////}
Function W32Chdir(s:String): longint;
 {change directory - with long filename support
 Use Ioresult as normal - if successful, IoResult will be 0
 if not successful, I implement a kludge to force an IO error
 so that IoResult <> 0
 }
Begin
    W32Chdir := -1;
    s:=StripChar(s,'"');

    {path starts with "\"}
    if (s[1]='\') then if Not IsUNC(s) then begin
       s:=ThisDrive+s;
    end;

    If (Use32Bit) then
    begin
    {I would use SetCurrentDirectory() here - but it doesn't work
     under NT - so I am using the system unit's ChDir procedure,
     with a long filename having been converted to a short filename}
      If W32IsDirectory(s) then begin
         System.ChDir(GetShortFName(s));
         if ioresult=0 then begin
           W32Chdir:=0;
           exit;
         end;
      end;
      {ChDir did not work; force an io error so that ioresult<>0}
      s:='Z:\Z\!$.'; {bad directory}
      System.ChDir(s);
    end {Use32bit}
    else begin
      System.ChDir(s)
    end;
End;
{/////////////////////////////////////////////////////////}
Function W32RmDir(s:String): longint;
{remove a directory - with long filename support;
 Use Ioresult as normal - if successful, IoResult will be 0
 if not successful, I implement a kludge to force an IO error
 so that IoResult <> 0
}
Var
i:integer;
p:array[0..260] of char;
b:longbool;

Begin
    W32RmDir := -1;
    s:=StripChar(s,'"');

    {path starts with "\"}
    if (s[1]='\') then if Not IsUNC(s) then begin
       s:=ThisDrive+s;
    end;

    If Use32Bit then begin
      Strpcopy(p, W32FullPathName(s));
      b:=RemoveDirectory(p);
      W32RmDir := GetLastError;

      if b = TRUE then
      begin
        W32RmDir := 0;
        i := ioresult;
      end {b=true}
      Else begin
         {force an io error so that ioresult<>0}
         s:='Z:\Z\!$.'; {bad directory}
         System.ChDir(s);
      end; {b=false}
    End {Use32Bit}
    else begin
      System.RmDir(s)
    End;
End;
{/////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////}
Function W32Rewrite(var fname:string):longint;
(*
 {Create a file, with long file name support, and
 return the short filename if the creation is successful
 Typical use:}

   var
   f:text;
   s:string;
   l:longint;

   begin
     s :='C:\MY Long fileName.Extension.See.Okay';
     l := W32Rewrite(s);  {create long name}
     If (l <> Invalid_Handle_Value) then begin {success}
       W32Close(l);  {make sure you close it!!!!!}
       Assign(f, s); {assign short name to your text file}
       ReWrite(f);   {now create it again - but you already have a long name!}
     end else Writeln('Error creating file');
   end.
*)
Var
l:longint;
Begin
   W32Rewrite:=-1;
   if not Use32Bit then exit;

   {if file exists - reset the attribute}
   SetFileAttributes(Str2PChar(FName), File_Attribute_Archive);

   l:= CreateFile(Str2pchar(fname),
   Generic_Read+Generic_Write,
   File_Share_Read,
   Nil,
   Create_Always,
   File_Attribute_Normal,
   0);
   W32Rewrite:=l;

   {if success, return short filename;for my own programs -
   to avoid having to do this manually each time}
   If l<>Invalid_Handle_Value then
   fName := GetShortFName(FName);
End;
{///////////////////////////////////////////////////////////}
Function W32Reset(fname:string):longint;
{open a file - with long filename support;
 Win32 file write functions must be used to write to the file}
Begin
   If Not Use32Bit then exit;
   W32Reset:= CreateFile(Str2pchar(fname),
   Generic_Read+Generic_Write,
   File_Share_Read,
   Nil,
   Open_Existing,
   File_Attribute_Normal,
   0);
End;
{///////////////////////////////////////////////////////////}
Function W32Close(handle:longint):longbool;
{Close a File handle}
Begin
   If Not Use32Bit then exit;
   W32Close:=CloseHandle(handle);
End;
{///////////////////////////////////////////////////////////}
{///////////////////////////////////////////////////////////}
function isUNC(Const s:string):boolean;
{is a file/directory name a UNC name?}
begin
   IsUNC := (s[1]='\') and (s[2]='\') and (Length(s) > 3);
end;
{/////////////////////////////////////////////////}
Function AddBackSlash(s:String):String;
{add a backslash if there wasn't one}
Begin
  if s[length(s)]<>'\' then s:=s+'\';
  AddBackSlash:=s;
End;
{/////////////////////////////////////////////////}
Function PathNameOnly(s:String):String;
{return the path only - strip filename out}
Var
i:word;
begin
   PathNameOnly:='';
   if (s[1] in ['\','/']) and (ISUnc(s)=False) then begin
     PathNameOnly:=s[1];
     exit;
   end;

   for i:=length(s) downto 0 do if s[i] in [':','\','/'] then break;
   if i>0 then begin
     s:=copy(s,1,i);
     if i > 1 then begin
       if s[pred(i)] in [':','\','/'] then {ignore} else
       begin
          if s[i]<>':' then Delete(s,i,1);
       end;
     end;
     PathNameOnly:=s;
   end;
end;
{/////////////////////////////////////////////////}
{/////////////////////////////////////////////////}
Function FileNameOnly(s:String):String;
{return the filename only - strip path out}
Var
i:Word;

begin
   FileNameOnly:=s;
   for i:=length(s) downto 0 do if s[i] in [':','\','/'] then break;
   if i>0 then
   begin
     Delete(s,1,i);
     FileNameOnly:=s;
   end;
end;
{/////////////////////////////////////////////////}
Function AddNull(S:String):String;
{add a null character to a string}
Var
i:Word;
Begin
   i:=length(s);
   If s[i]<>#0 then s[i]:=#0;
   AddNull := s;
End;
{/////////////////////////////////////////////////}
Function StripChar(s:string;ch:char):string;
{remove all occurences of "ch" from "s"}
var
i:Word;
begin
   for i:=1 to length(s) do
   if s[i]=ch then Delete(s,i,1);
   StripChar:=s;
end;
{/////////////////////////////////////////////////}
Function StripQuotes(s:String):String;
{remove beginning and ending quotation marks from a string }
Var
i:word;
Begin
  i:=length(s);
  If (s[1]='"') and (s[i]='"') then begin
    Delete(s,i,1);
    Delete(s,1,1);
  end;
  StripQuotes:=s;
End;
{/////////////////////////////////////////////////}
Function Str2PChar(Var S:String):PChar;
{convert a string to a pchar}
Var
i :word;
s1:string;
Begin
   s1:=s;
   i:=length(s);
   If s[i]<>#0 then s:=s+#0;
   Str2PChar:=@s[1];
   s:=s1;
End;
{/////////////////////////////////////////////////////////}
Function W32ShowDir:String;
{get the current directory name - with long name support}
Var
p:array[0..260] of char;
s1,
s:string;
Begin
    If Use32Bit then
    begin
      GetCurrentDirectory(260, p);
      s1:=AddBackSlash(GetLongFName(PathNameonly(Strpas(p))));
      s:=GetLongFName(Strpas(p));
      s :=s1+FileNameOnly(s);
      W32ShowDir:=s;
    end
    else
    begin
      GetDir(0, s);
      W32ShowDir:=s;
    end;
End;
{/////////////////////////////////////////////////}
Function GetShortFName(FName:String):String;
{get the short name of a file name - doesn't exist in NT 3.1}
Var
Temp:Pchar;
Begin
   GetShortFName := FName;
   If Not Use32Bit then Exit;
   Fname:=Fname+#0;
   getmem(temp, 261);
   If GetShortPathName(@Fname[1],Temp,260)>0 then
   GetShortFName := StrPas(temp);
   freemem(temp, 261);
End;
{/////////////////////////////////////////////////}
Function W32GetLongFileName(Ind:pChar;NumChar:LongInt;Ud:pChar):LongInt;
{get a long filename from short one}
Var
  W      : Longint;
  L      : WIN32_FIND_DATA;
  Old,SeekIt,TheEnd,Ind1,
  Temp2  : pChar;
Begin
  If Not(Use32Bit) then begin
    GetMem(Ind1,512);
    While (Strlen(Ind)>0) and ((StrEnd(Ind)-1)^='\') DO
      (StrEnd(Ind)-1)^:=#0;
    getFullPathName(Ind,512,Ind1);
    If Not(ExistFileOrDirectory(Ind1)) Then
      Ud[0]:=#0
    Else
      StrLCOPy(Ud,Ind1,NumChar);
    FreeMem(Ind1,512);
  End else Begin
    GetMem(Ind1,512);
    GetMem(Old,512);
    GetMem(TheEnd,512);
    getFullPathName(Ind,512,Ind1);
    If Not(ExistFileOrDirectory(Ind1)) Then
      Ind1[0]:=#0;
    If IsUncP(Ind1) then
      Temp2:=StrScan(StrScan(StrScan(StrScan(Ind1,'\')+1,'\')+1,'\')+1,'\')
    Else
      Temp2:=StrScan(Ind1,'\');
    If Temp2<>Nil Then Begin
      Temp2[0]:=#0;
      StrCopy(Old,Ind1);
      Temp2[0]:='\';
      StrCopy(TheEnd,Old);
      Inc(temp2);
      SeekIt:=StrScan(Temp2,'\');
      While SeekIt<>Nil Do Begin
        SeekIt[0]:=#0;
        StrCat(Old,'\');
        StrCat(Old,Temp2);
        SeekIt[0]:='\';
        Temp2:=SeekIt+1;
        SeekIt:=StrScan(Temp2,'\');
        W:=FindFirstfile(Old,L);
        StrCat(TheEnd,'\');
        StrCat(TheEnd,L.cFileName);
        FindClose(W);
      End;
      If Temp2[0]<>#0 Then Begin
        StrCat(Old,'\');
        StrCat(Old,Temp2);
        W:=FindFirstfile(Old,L);
        StrCat(TheEnd,'\');
        StrCat(TheEnd,L.cFileName);
        FindClose(W);
      End;
      StrLCopy(Ud,TheEnd,NumChar);
    End Else Ud[0]:=#0;
    FreeMem(TheEnd,512);
    FreeMem(Old,512);
    FreeMem(Ind1,512);
  End;
  While (Strlen(Ud)>0) and ((StrEnd(Ud)-1)^='\') DO (StrEnd(Ud)-1)^:=#0;
  W32GetLongFileName:=Strlen(Ud);
End;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Function GetLongFName(Const FName:String):String;
{get a long filename, using a String instead of PChar}
var
p:pchar;
s1,
s:^string;
begin
  GetLongFName:=FName;
  getmem(p, 261);
  new(s);
  new(s1);

  s^:=FName;
  If ExistDirectory(Str2PChar(s^)) then {it's a directory}
  begin
     getdir(0, s1^);
     System.chdir(GetShortFName(s^));
     if ioresult=0 then begin
       getdir(0, s^);
     end;
     system.chdir(s1^); if ioresult=0 then;
  end;

  If W32GetLongFileName(Str2PChar(s^), 260, p)>0 then
  begin
    If (Length(FName)=3) and (Fname[2]=':') and (Fname[3]='\')
    then {its a root directory - don't change it}
    else
    GetLongFName:=StrPas(p);
  end;
  freemem(p, 261);
  dispose(s);
  dispose(s1);
end;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
Function GetFullFName(Const FName:String):String;
Var
p2,
p:pchar;
s1,s2:string;

Begin
    GetFullFName:=FName;
    If Not Use32Bit then Exit;

    getDir(0, s2);{save current}
    s1:=PathnameOnly(FName);
    if s1>'' then begin
       System.Chdir(GetShortFName(s1));
       if ioresult=0 then;
    end;

    s1:=FName;

    getmem(p, 261);
    getmem(p2, 255);

    strpcopy(p2, s1);
    If GetFullPathName(p2, 260, p)>0
    then begin
       GetFullFName:= StrPas(p);
    end;

    System.Chdir(s2); if ioresult=0 then;

    freemem(p, 261);
    freemem(p2, 255);
End;
{/////////////////////////////////////////////////}
Function W32Move(TheOld, TheNew:String):longbool;
{move a file, by renaming it; if TheNew exists,
it will try to delete it and then do a rename}
Var
b:longbool;
Begin
    W32Move:=False;
    If Not Use32Bit then exit;

    b := MoveFile(Str2PChar(TheOld), Str2PChar(TheNew));
    if not b then
    begin  {error}
       If W32Exist(TheOld) then {does the old file exist?}
       begin
          If DeleteFile(Str2PChar(TheNew)) {try to delete the new one}
          then                             {if success, then move again}
          b := MoveFile(Str2PChar(TheOld), Str2PChar(TheNew));
       end;
    end;
    W32Move := b;
End;
{/////////////////////////////////////////////////}
Function W32Rename(TheOld, TheNew:String):longbool;
{rename a file - TheNew must not exist already}
Var
b:longbool;
Begin
    If Not Use32Bit then exit;
    b := MoveFile(Str2PChar(TheOld), Str2PChar(TheNew));
    W32Rename := b;
End;
{/////////////////////////////////////////////////////////}
Function W32Exist(Var FName:String):Boolean;
Var
i:longint;
s,s1,s2:string;
Begin
   If Not Use32Bit then exit;
   getDir(0, s2);{save current}

   s1:= StripChar(FName,'"');
   s1:=PathnameOnly(s1);

   If s1>'' then begin
     System.Chdir(GetShortFName(s1));
      if ioresult=0 then begin
         GetDir(0,s1);
         If Not IsUNC(FName) then
         FName := AddBackSlash(GetLongFName(s1))+FileNameOnly(FName);
      end;
   end;

   W32Exist:=False;
   i:= CreateFile(Str2pchar(FName),Generic_Read,File_Share_Read,
   Nil,Open_Existing,File_Attribute_Normal,0);
   if i <> Invalid_Handle_Value then begin
      CloseHandle(i);
      W32Exist:=True;
      If Not IsUNC(FName) then begin
        s := PathNameOnly(FName);
        s1:= GetLongFName(FName);
        If (s = '') then FName:=s1
        else FName:=AddBackSlash(s)+FileNameOnly(s1);
      end;
   end;
   System.Chdir(s2);if ioresult<>0 then;
End;
{/////////////////////////////////////////////////////////}
Function W32IsDirectory(Var DirName:String):Boolean;
{does the directory DIRNAME exist?}
Var
s1,s2:string;

Begin
   W32IsDirectory:=False;
   If DirName='' then Exit;
   If Not Use32Bit then exit;

   s1:=DirName;
   getDir(0, s2);{save current}
   s1:=GetShortFName(DirName);
   s1:=StripChar(s1,'"');

   System.Chdir(s1);
   if ioresult<>0 then System.Chdir(StripChar(DirName,'"'));
   if ioresult=0 then begin
      W32IsDirectory:=True;
      If Not IsUNC(DirName) then {don't touch UNC names}
      begin
        GetDir(0,s1);
        DirName := GetLongFName(s1); {return s1}
      end;
   end;
   System.Chdir(s2);if ioresult<>0 then;
End;
{/////////////////////////////////////////////////////////}
Function Stupcase(Const s:String):String;
{convert a string to uppercase}
Var
p:pchar;
i:Word;
Begin
    i := length(s)+1;
    getmem(p, i);
    strpcopy(p, s);
    AnsiUpper(p);
    Stupcase:=StrPas(p);
    freemem(p, i);
End;
{/////////////////////////////////////////////////////////}
Function IsWin32OS:Boolean;
{Returns whether we can use 32-bit functions or not}
Begin
   IsWin32OS:=Use32Bit;
End;
{/////////////////////////////////////////////////////////}
Function  SetWin32OSValue(Const Enable:Boolean):Boolean;
{to change Win32stuff on the fly; returns the old value
of Use32Bit}
Begin
    SetWin32OSValue:=Use32Bit; {return old value}
    If Enable=True then
    begin
       If Call32NTError=True then Exit;{Error in Call32NT - don't set}
       Use32Bit:=True;
    end
    else Use32Bit:=False;
End;
{/////////////////////////////////////////////////////////}
Function GetVersionEx(Var Info:OSVersionInfo):LongBool;
Begin
  GetVersionEx := False;
  If Use32Bit then begin
     GetVersionEx := W32GetVersionEx(Info, Id_W32GetVersionEx);
  end;
End;
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
{////////// initialisation section  //////////////////////}
{/////////////////////////////////////////////////////////}
{/////////////////////////////////////////////////////////}
begin
  InitialiseWin32;
end.
