{
 *************************************************************************
 *
 *                         PESHOW.PAS
 *
 * Demo Program read and display Win32 PE header information
 * Author : Prof. Abimbola A Olowofoyeku <African_Chief@bigfoot.com>
 *
 * Supports : virtually all Pascal compilers;
 *   * GNU Pascal, Turbo Pascal, Borland Pascal, Virtual Pascal
 *   * Delphi
 *
 * Licence: This code is released as FREEWARE, and is supplied
 *          WITHOUT ANY WARRANTIES WHATSOEVER
 *
 * (c)2000,2001 Prof. Abimbola A Olowofoyeku (The African Chief)
 *
 **************************************************************************
}

PROGRAM PESHOW;

{$i-}

USES peunit;

CONST
  fmOpenRead       = $0000;
  fmShareDenyWrite = $0020;

VAR
f : file;
l : Longint;
x : {$ifdef ver70}integer{$else}longint{$endif};
r : Longint;
pe : PE_HeaderRec;

PROCEDURE Abort ( s : String );
BEGIN
  Close ( f ); IF ioresult <> 0 THEN;
  Writeln ( s );
  Halt ( 1 );
END;

BEGIN
  FillChar ( pe, Sizeof ( pe ), #0 );
  IF ParamCount > 0
  THEN BEGIN
     Assign ( f, paramstr ( 1 ) );
     filemode := fmOpenRead OR fmShareDenyWrite;
     reset ( f, 1 );
     IF ioresult <> 0 THEN Abort ( 'Error opening ' + paramstr ( 1 ) + '.' );

     l := ReadWholePEHeader ( f, pe );
     CASE l OF
        - 1 : Abort ( paramstr ( 1 ) + ' is not an executable file.' );
        - 2 : Abort ( paramstr ( 1 ) + ' is a dos real mode program!' );
        - 3 : Abort ( paramstr ( 1 ) + ' is a Win16 or OS/2 program!' );  { Win16 or OS/2 EXE    }
        - 4 : Abort ( paramstr ( 1 ) + ' is an OS/2 program!' ); { OS/2 Exe }
     END;

     close ( f );

     { display }
     Writeln ( 'PE header dump of: ', paramstr ( 1 ) );
     WITH pe.PEHeader DO BEGIN
        Writeln ( 'Machine                 = ', Machine );
        Writeln ( 'Number of Sections      = ', NumberOfSections );
        Writeln ( 'Date/Time Stamp         = ', TimeDateStamp );
        Writeln ( 'Symbol Table Location   = ', PointerToSymbolTable );
        Writeln ( 'Number of Symbols       = ', NumberOfSymbols );
        Writeln ( 'Optional Header Size    = ', SizeOfOptionalHeader );
        Writeln ( 'Characteristics         = ', Characteristics );
     END;

     WITH pe.OptionalHeader DO BEGIN
        Writeln ( 'Magic Number            = ', Magic );
        Writeln ( 'Major Linker Version    = ', MajorLinkerVersion );
        Writeln ( 'Minor Linker Version    = ', MinorLinkerVersion );
        Writeln ( 'Code Size               = ', SizeOfCode );
        Writeln ( 'Initialized data size   = ', SizeOfInitializedData );
        Writeln ( 'Uninitialized data size = ', SizeOfUninitializedData );
        Writeln ( 'Address of entry point  = ', AddressOfEntryPoint );
        Writeln ( 'Base of Code            = ', BaseOfCode );
        Writeln ( 'Base of Data            = ', BaseOfData );

        Writeln ( 'Image Base              = ', ImageBase );
        Writeln ( 'Section Alignment       = ', SectionAlignment );
        Writeln ( 'File Aligment           = ', FileAlignment );
        Writeln ( 'OS Major Version        = ', MajorOperatingSystemVersion );
        Writeln ( 'OS Minor Version        = ', MinorOperatingSystemVersion );
        Writeln ( 'Major Image Version     = ', MajorImageVersion );
        Writeln ( 'Minor Image Version     = ', MinorImageVersion );
        Writeln ( 'Major SubSystem Version = ', MajorSubsystemVersion );
        Writeln ( 'Minor SubSystem Version = ', MinorSubsystemVersion );
        Writeln ( 'Reserved                = ', Reserved1 );
        Writeln ( 'Size of Image           = ', SizeOfImage );
        Writeln ( 'Size of Headers         = ', SizeOfHeaders );
        Writeln ( 'File Checksum           = ', CheckSum );
        Writeln ( 'Subsystem               = ', Subsystem );
        Writeln ( 'DLL Characteristics     = ', DllCharacteristics );
        Writeln ( 'Reserve Stack Size      = ', SizeOfStackReserve );
        Writeln ( 'Committed Stack Size    = ', SizeOfStackCommit );
        Writeln ( 'Reserve Heap Size       = ', SizeOfHeapReserve );
        Writeln ( 'Committed Heap Size     = ', SizeOfHeapCommit );
        Writeln ( 'Loader Flags            = ', LoaderFlags );
        Writeln ( 'Number of RVA and Sizes = ', NumberOfRvaAndSizes );

        { read sections }
        Reset ( f, 1 );
        l := PESectionHeaderOffSet ( f );
        Seek ( f, l );
        Writeln;
        Writeln ( 'Data Sections: ' );
        Writeln ( '--------------' );
        FOR r := 0 TO Pred ( pe.PEHeader.NumberOfSections )
        DO BEGIN
           BlockRead ( f, pe.SectionHeader, Sizeof ( pe.SectionHeader ), x );
           WITH pe.SectionHeader
           DO BEGIN
                Writeln ( 'Section Name:     ', Name );
                Writeln ( 'Virtual Address:  ', VirtualAddress );
                Writeln ( 'Size of Data :    ', SizeOfRawData );
                Writeln ( 'Pointer to Data : ', PointerToRawData );
                Writeln ( '---------------------------' );
           END;
        END;
        Close ( f ); IF ioresult <> 0 THEN;
     END;
  END ELSE BEGIN
     Writeln ( 'Syntax = peshow <filename>' );
  END;
END.

