{ **********************************************************************
  **    THIS CODE IS FREEWARE, AND IS SUPPLIED WITH NO WARRANTIES
  **
  **                  htz_clx_unit.pas
  **
  **    a GUI unit to decompress or create "htz" files
  **    uses the PasZlib libraries from:
  **            http://www.nomssi.de/paszlib/paszlib.html
  **
  **   This is the CLX version (portable between Windows and Linux)
  **
  **   Author:
  **       Prof Abimbola A Olowofoyeku (The African Chief)
  **            http://www.greatchief.plus.com/
  **
  **       Version:             1.04.9
  **       Last Modified:       5th August 2004
  **********************************************************************
}

unit htz_clx_unit;

interface

uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms, 
  QDialogs, QStdCtrls, QMenus, QComCtrls, QButtons, QExtCtrls, IniFiles;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    Open1: TMenuItem;
    Reopen1: TMenuItem;
    Close1: TMenuItem;
    Save1: TMenuItem;
    N2: TMenuItem;
    BatchConvert1: TMenuItem;
    Exit1: TMenuItem;
    FromHTZ1: TMenuItem;
    ToHTZ1: TMenuItem;
    Edit1: TMenuItem;
    View1: TMenuItem;
    Format1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    N3: TMenuItem;
    Checkforupdates1: TMenuItem;
    N4: TMenuItem;
    TheAfricanChiefs1: TMenuItem;
    Font1: TMenuItem;
    Preview1: TMenuItem;
    Undo1: TMenuItem;
    N5: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    N6: TMenuItem;
    Find1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    FontDialog1: TFontDialog;
    FindDialog1: TFindDialog;
    ReplaceDialog1: TReplaceDialog;
    ToolBar1: TToolBar;
    ExitButton: TSpeedButton;
    PreviewButton: TSpeedButton;
    FontButton: TSpeedButton;
    LinkButton: TSpeedButton;
    FindButton: TSpeedButton;
    SaveButton: TSpeedButton;
    CloseButton: TSpeedButton;
    OpenButton: TSpeedButton;
    StatusBar1: TStatusBar;
    RichEdit1: TMemo;
    procedure OpenButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure SaveButtonClick(Sender: TObject);
    procedure FindButtonClick(Sender: TObject);
    procedure LinkButtonClick(Sender: TObject);
    procedure FontButtonClick(Sender: TObject);
    procedure PreviewButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure RichEdit1Enter(Sender: TObject);
    procedure RichEdit1KeyPress(Sender: TObject; var Key: Char);
    procedure RichEdit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FromHTZ1Click(Sender: TObject);
    procedure ToHTZ1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Checkforupdates1Click(Sender: TObject);
    procedure TheAfricanChiefs1Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure FindDialog1Find(Sender: TObject);
  PRIVATE
    { Private declarations }
    OpenedFiles : TStringList;
    PROCEDURE CheckSave;
    PROCEDURE UpdateStatus ( Sender : TObject );
    PROCEDURE SubMenuClick ( Sender : TObject );
    FUNCTION  EditingHtm : Boolean;
    FUNCTION  TextAtCursor : String;
    PROCEDURE UpdateMRU;
  PUBLIC
    { Public declarations }
    PROCEDURE OpenHTZFile ( CONST FName : String );
  end;

var
  Form1: TForm1;

implementation

uses
{$ifdef Win32}
Windows,
ShellApi,
{$else}
libc,
{$endif}
htz_unit;
{$R *.xfm}

CONST
Slash = {$ifdef Win32}'\'{$else} '/'{$endif};
MaxExtensions = 4;
Extensions : ARRAY [1..MaxExtensions] OF String = ( 'htz', 'htm', 'txt', '' );
htz_filter = 1;
htm_filter = 2;
txt_filter = 3;
all_filter = 4;
StandardFilter = 'HTZ files|*.htz;*.*_z|HTML files|*.htm|Text files|*.txt|All files|*.*';
MyUrl = 'http://www.greatchief.plus.com/';
UpdateUrl = 'http://www.greatchief.plus.com/origo.htm';
BrowserName = 'konqueror';

{ batch conversion }
CONST
MaxConverts = 5;
HTZExtensions : ARRAY [1..MaxConverts] OF string =
( 'htz', 'htz', 'jsz', 'dlz', 'z' );

NormalExtensions : ARRAY [1..MaxConverts] OF string =
( 'htm', 'html', 'js', 'dl', '' );

VAR
tmp,
srcfile,
destfile : string;
IniFile : TIniFile;

FUNCTION ExecuteFile ( CONST FileName, Params, DefaultDir : string;
  ShowCmd : Integer ) : Integer;
VAR
zFileName, zParams, zDir : ARRAY [0..511] OF Char;
 {$ifndef Win32}
 pid : pid_t;
{$endif}
BEGIN
  StrPCopy ( zFileName, FileName );
  StrPCopy ( zParams, Params );

 {$ifdef Win32}
  Result := ShellApi.ShellExecute ( 0, NIL,
    zFileName, zParams, StrPCopy ( zDir, DefaultDir ), ShowCmd );
 {$else}
   StrPCopy ( zParams, BrowserName );
   If Params = ''
    then StrPCopy ( zFileName, FileName )
      else
        StrPCopy( zFileName, FileName + ' ' + Params  );
   pid := Libc.fork;
   if pid = 0
   then begin
      Libc.execlp ( zParams, zParams, zFileName, NIL );
      Libc._Exit ( Exit_Failure );
   end else Result := -1;
  //Libc.execlp(pChar (BrowserName), pChar (FileName + ' ' + Params));
  //Result := Libc.system (pChar (BrowserName + ' ' + FileName + ' ' + Params));
 {$endif}
END;


FUNCTION TempDirectory : String;
VAR
p : Array [0..1024] of char;
BEGIN
   Result := Slash + 'tmp';
  {$ifdef Win32}
   If GetTempPath (1024, p) > 0 then Result := Strpas (p);
  {$else}
  {$endif}
END;

FUNCTION AddBackSlash ( CONST s : String ) : String;
BEGIN
   IF ( s [length ( s ) ] = Slash )
     THEN Result := s
        ELSE Result := s + Slash;
END; { AddBackSlash }

FUNCTION JustExtension ( CONST s : String ) : String;
BEGIN
   Result := ExtractFileExt ( s );
   IF ( Result > '' ) AND ( Result [1] = '.' ) THEN Delete ( Result, 1, 1 );
END; { JustExtension }

FUNCTION FindFilterIndex ( CONST s : String ) : Byte;
VAR
s1 : String;
i : Byte;
BEGIN
   Result := htm_filter;
   s1 := ExtractFileExt ( s );
   IF s1 > ''
   THEN BEGIN
      Delete ( s1, Pos ( '.', s1 ), 1 );
      i := 1;
      WHILE i < 4
      DO BEGIN
        IF AnsiCompareText ( s1, Extensions [i] ) = 0
        THEN BEGIN
           Result := i;
           Exit;
        END;
        Inc ( i );
      END;
      Result := i;
   END;
END; { GetFilterIndex }

{ callback routine }
FUNCTION MyCallBack ( CONST Data; CONST DataSize : Longint ) : Longint; STDCALL;
VAR
p : pchar;
BEGIN
   p := pchar ( @Data );
   p [ DataSize ] := #0;
   Form1.RichEdit1.Lines.Add ( p );
   Result := Strlen ( p );
END; { MyCallBack }

PROCEDURE TForm1.CheckSave;
BEGIN
   WITH RichEdit1
   DO BEGIN
      IF Modified
      THEN BEGIN
        IF MessageDlg ( 'Do you want to save the file?', mtConfirmation, mbYesNoCancel, 0 )
        = mrYes THEN SaveButtonClick ( Self );

         CloseButtonClick ( Self );
      END;
      Clear;
      Modified := False;
   END;
END;

procedure TForm1.OpenButtonClick(Sender: TObject);
begin
   IF OpenDialog1.Execute
   THEN BEGIN
      OpenHTZFile ( OpenDialog1.FileName );
   END;
end;

procedure TForm1.CloseButtonClick(Sender: TObject);
begin
  srcfile := '';
  destfile := '';
  Richedit1.Lines.Clear;
  SaveButton.Enabled := False;
  Save1.Enabled := False;
  CloseButton.Caption := 'Close';
  Close1.Caption := 'Close';
  CloseButton.Enabled := False;
  Find1.Enabled := CloseButton.Enabled;
  FindButton.Enabled := Find1.Enabled;
  PreviewButton.Enabled := False;
  Close1.Enabled := False;
  UpdateStatus ( Self );
end;

procedure TForm1.SaveButtonClick(Sender: TObject);
Var
p : Array [0..511] of char;
BEGIN
   WITH RichEdit1
   DO BEGIN
       IF ( Lines.Count > 0 )
       THEN BEGIN
          IF SaveDialog1.Execute
          THEN BEGIN
             SaveDialog1.DefaultExt := Extensions [SaveDialog1.filterindex];
             SaveDialog1.filename := ChangeFileExt ( SaveDialog1.filename, '.' + SaveDialog1.DefaultExt );
             IF ( SaveDialog1.filterindex = htz_filter ) { compress to HTZ file }
             THEN BEGIN
                 destfile := SaveDialog1.FileName + '.tm$';
                 StrpCopy ( p, SaveDialog1.FileName );
                 Lines.SaveToFile ( destfile );
                 IF CompressFile ( pChar ( destfile ), p ) < 1
                 THEN BEGIN
                    ShowMessage ( 'Error writing to ' + SaveDialog1.FileName );
                 END;
                 Sysutils.DeleteFile ( destfile );
                 destfile := SaveDialog1.FileName;
             END
             ELSE BEGIN { save to HTML or text or other file }
                 destfile := SaveDialog1.FileName;
                 Lines.SaveToFile ( destfile );
             END;
             StatusBar1.SimpleText := destfile;
             Modified := False;
             SaveDialog1.filterindex := htm_filter;
             SaveDialog1.DefaultExt := Extensions [SaveDialog1.filterindex];
          END;
       END;
   END;
END;

procedure TForm1.FindButtonClick(Sender: TObject);
VAR
s : String;
BEGIN
   WITH FindDialog1
   DO BEGIN
      FindText := '';
      s := TextAtCursor;
      IF s <> '' THEN FindText := s;
      Options := [frHideUpDown, frDown];
      Execute;
   END;
END;

procedure TForm1.LinkButtonClick(Sender: TObject);
VAR
s : String;
BEGIN
   s := '';
   IF ( RichEdit1.SelText > '' ) THEN
      WITH RichEdit1
      DO BEGIN
          s := InputBox ( 'Create Hyperlink for "' + SelText + '"',
                        'URL for "' + Seltext + '"',
                        'http://www.' );
          IF ( s <> '' ) AND ( s <> 'http://www.' )
          THEN BEGIN
             SelText := '<a href="' + s + '">' + Seltext + '</a>';
          END;
      END;
END;

procedure TForm1.FontButtonClick(Sender: TObject);
begin
  WITH FontDialog1
  DO BEGIN
     IF Execute THEN RichEdit1.Font := Font;
  END;
end;

procedure TForm1.PreviewButtonClick(Sender: TObject);
VAR
s : String;
BEGIN
   WITH RichEdit1 DO
   IF EditingHtm
   THEN BEGIN
      s := AddBackSlash ( TempDirectory ) + '_tmp_.htm';
      Lines.SaveToFile ( s );
      ExecuteFile ( s, '', '', {$ifdef Win32}SW_SHOW{$else}0{$endif} );
   END;
END;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

PROCEDURE TForm1.UpdateStatus ( Sender : TObject );
VAR
MemoLine,
Memo_column : integer;
BEGIN
   WITH RichEdit1
   DO BEGIN
      LinkButton.Enabled := SelText > '';
      IF Lines.Count = 0 THEN StatusBar1.SimpleText := ''
      ELSE BEGIN
         MemoLine := CaretPos.Line;
         Memo_column  := CaretPos.Col;
         StatusBar1.SimpleText :=
         inttostr ( Lines.Count ) + ' lines, ' +
         inttostr ( MemoLine + 1 ) + ' : ' + inttostr ( Memo_column + 1 ) + '  (' + srcfile + ')';
      END;
   END;
END;

PROCEDURE TForm1.SubMenuClick ( Sender : TObject );
Var
s : String;
BEGIN
   WITH TMenuItem ( Sender )
   DO BEGIN
      s := Caption;
      While Pos ('&', s) > 0 do System.Delete (s, Pos ('&', s), 1);
      OpenHTZFile ( s );
   END;
END;

{ a simple test to check whether we are editing an HTML file }
FUNCTION  TForm1.EditingHtm : Boolean;
VAR
s : String;
BEGIN
   Result := False;
   WITH RichEdit1
   DO BEGIN
      IF ( Lines.Count > 0 )
      THEN BEGIN
         s := UpperCase ( Lines.Text );
         Result :=
         ( 
                ( Pos ( '<HTML>', s ) > 0 )
         OR     ( Pos ( '<TITLE>', s ) > 0 )
         OR     ( Pos ( '<BODY>', s ) > 0 )
         OR     ( Pos ( '<HEAD>', s ) > 0 )
         )
         AND
         ( 
                ( Pos ( '</HTML>', s ) > 0 )
         OR     ( Pos ( '</TITLE>', s ) > 0 )
         OR     ( Pos ( '</BODY>', s ) > 0 )
         OR     ( Pos ( '</HEAD>', s ) > 0 )
         )
      END;
   END;
END;

FUNCTION TForm1.TextAtCursor : String;
VAR
s : string;
i, j : Longint;
BEGIN
  WITH RichEdit1
  DO BEGIN
     IF SelText > ''
     THEN BEGIN
        Result := SelText;
        Exit;
     END;

     SelLength := 25;
     s := SelText;
     s := Trim ( s );
     SelLength := 0;
     FOR i := 2 TO length ( s )
     DO BEGIN
         IF s [i] IN [#13, #10, #32, ',', ':', '=', ';', '.', '+']
         THEN BEGIN
            j := i;
            Delete ( s, j, length ( s ) );
            Break;
         END;
     END;
     Result := s;
  END;
END;

PROCEDURE TForm1.UpdateMRU;
VAR
i : longint;
t : TMenuItem;
BEGIN
   FOR i := ReOpen1.Count - 1 DOWNTO 0
   DO BEGIN
       Reopen1.Delete ( i );
   END;

   FOR i := 0 TO OpenedFiles.Count - 1
   DO BEGIN
      t := TMenuItem.Create ( Self );
      WITH t DO BEGIN
           Caption := OpenedFiles [i];
           MenuIndex := 0;
           OnClick := SubMenuClick;
      END;
      Reopen1.Add ( t );
   END;
END;

PROCEDURE TForm1.OpenHTZFile ( CONST FName : String );
VAR
src, dest : String;
i : longint;
BEGIN
   IF Trim ( FName ) = '' THEN Exit;
   CheckSave;
   OpenDialog1.FileName := FName;
   src := OpenDialog1.FileName;
   SaveDialog1.FilterIndex := FindFilterIndex ( src );
   i := IsHTZFile ( pChar ( src ) );
   LinkButton.Enabled := RichEdit1.SelText > '';
   IF i > 0
   THEN BEGIN
      dest := ChangeFileExt ( src, '.tmp' );
      RichEdit1.Lines.Clear;
      IF UnCompressFileEx ( pChar ( src ), pChar ( dest ), MyCallBack ) > 0
      THEN BEGIN
        srcfile := src;
        destfile := dest;
        SaveButton.Enabled := True;
        Save1.Enabled := True;
        CloseButton.Enabled := True;
        Find1.Enabled := CloseButton.Enabled;
        FindButton.Enabled := Find1.Enabled;
        PreviewButton.Enabled := EditingHtm;
        Close1.Enabled := True;
      END;
      Sysutils.DeleteFile ( dest );
   END
   ELSE BEGIN
        RichEdit1.Lines.LoadFromFile ( src );
        srcfile := src;
        destfile := src;
        SaveButton.Enabled := True;
        Save1.Enabled := True;
        CloseButton.Enabled := True;
        Find1.Enabled := CloseButton.Enabled;
        FindButton.Enabled := Find1.Enabled;
        PreviewButton.Enabled := EditingHtm;
        Close1.Enabled := True;
   END; { isHTZFile }

   Reopen1.Enabled := True;
   SaveDialog1.FileName := srcfile;
   StatusBar1.SimpleText := srcfile;
   OpenedFiles.Add ( srcfile );
   
   WITH RichEdit1
   DO BEGIN
      Modified := False;
      SetFocus;
      {$ifdef Win32}
      SetCaretPos (1, 1);
      {$endif}
      SelStart := 0;
      SelLength := 0;
   END;
   UpdateMRU;
   UpdateStatus ( Self );
END;

{//////////////////////////}
procedure TForm1.RichEdit1Enter(Sender: TObject);
begin
  LinkButton.Enabled := RichEdit1.SelText > '';
end;

procedure TForm1.RichEdit1KeyPress(Sender: TObject; var Key: Char);
begin
  LinkButton.Enabled := RichEdit1.SelText > '';
end;

procedure TForm1.RichEdit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  LinkButton.Enabled := RichEdit1.SelText > '';
  UpdateStatus ( Sender );
end;

procedure TForm1.FromHTZ1Click(Sender: TObject);
VAR
i, j : Cardinal;
f, s, s1 : String;
s2 : WideString;
BEGIN
  CheckSave;
  WITH OpenDialog1
  DO BEGIN
     f := Filter;
     Filter := 'HTZ files|*.htz;*.jsz;*.dlz;*.z;*.*_z';
     tmp := Title;
     Title := 'Decompress HTZ format file(s)';
     Options := Options + [ofAllowMultiSelect];
     FilterIndex := htz_filter;
     IF Execute
     THEN BEGIN
        IF NOT SelectDirectory ( 'Output directory', '.', s2)
        THEN Exit;

        FOR i := 0 TO Pred ( Files.Count )
        DO
        IF IsHTZFile ( pChar ( Files [i] ) ) > 0   // test TO see that it IS an HTZ FILE
        THEN BEGIN
           s := JustExtension ( Files [i] );
           IF ( s > '' ) AND ( Pos ( '_z', LowerCase ( s ) ) > 0 )
           THEN BEGIN
              s1 := Files [i];
              Delete ( s1, Length ( s1 ) - 1, 2 )
           END ELSE s1 := ChangeFileExt ( Files [i], '.htm' );

           FOR j := 1 TO MaxConverts
           DO
           IF AnsiCompareText ( s, HTZExtensions [j] ) = 0
           THEN BEGIN
               s1 := ChangeFileExt ( s1, '.' + NormalExtensions [j] );
               Break;
           END;

           s1 := AddBackSlash ( s2 ) + ExtractFileName ( s1 );
           IF UnCompressFile ( pChar ( Files [i] ), pChar ( s1 ) ) > 0
           THEN BEGIN
              RichEdit1.Lines.Add ( Files [i] + ' ----> ' + s1 );
           END;
        END;
        IF RichEdit1.Lines.Count > 0
        THEN BEGIN
           CloseButton.Caption := 'Clear';
           Close1.Caption := 'Clear';
           CloseButton.Enabled := True;
           Find1.Enabled := CloseButton.Enabled;
           FindButton.Enabled := Find1.Enabled;
           Close1.Enabled := True;
        END;
        RichEdit1.Modified := False;
     END;
     Title := tmp;
     Options := Options - [ofAllowMultiSelect];
     Filter := f;
  END;
end;

procedure TForm1.ToHTZ1Click(Sender: TObject);
VAR
i, j : Cardinal;
s, s1 : String;
s2 : WideString;
BEGIN
  CheckSave;
  WITH OpenDialog1
  DO BEGIN
     tmp := Title;
     Title := 'Convert files(s) to HTZ format';
     Options := Options + [ofAllowMultiSelect];
     FilterIndex := all_filter;
     IF Execute
     THEN BEGIN

        IF NOT SelectDirectory ( 'Output directory', '.', s2)
        THEN Exit;
        
        FOR i := 0 TO Pred ( Files.Count )
        DO
        IF IsHTZFile ( pChar ( Files [i] ) ) <= 0 // test TO see that it IS NOT an HTZ FILE
        THEN BEGIN
           s := JustExtension ( Files [i] );
           IF s > '' THEN BEGIN
              s1 := Files [i] + '_z';     // e.g., foo.pas - > foo.pas_z
           END ELSE s1 := ChangeFileExt ( Files [i], '.z' );

           FOR j := 1 TO MaxConverts DO
           IF AnsiCompareText ( s, NormalExtensions [j] ) = 0
           THEN BEGIN
               s1 := ChangeFileExt ( s1, '.' + HTZExtensions [j] );
               Break;
           END;

           s1 := AddBackSlash ( s2 ) + ExtractFileName ( s1 );
           IF CompressFile ( pChar ( Files [i] ), pChar ( s1 ) ) > 0
           THEN BEGIN
              RichEdit1.Lines.Add ( Files [i] + ' ----> ' + s1 );
           END;
        END;
        IF RichEdit1.Lines.Count > 0
        THEN BEGIN
           CloseButton.Caption := 'Clear';
           Close1.Caption := 'Clear';
           CloseButton.Enabled := True;
           Find1.Enabled := CloseButton.Enabled;
           FindButton.Enabled := Find1.Enabled;
           Close1.Enabled := True;
        END;
        RichEdit1.Modified := False;
     END;
     Title := tmp;
     Options := Options - [ofAllowMultiSelect];
  END;
END;

procedure TForm1.FormActivate(Sender: TObject);
begin
   IF ParamCount > 0 THEN OpenHTZFile ( ParamStr ( 1 ) );
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
VAR
t : TStringList;
i, j : Integer;
s : String;
BEGIN
   CheckSave;
   t := TStringList.Create;
   t.Duplicates := DupIgnore;
   WITH IniFile
   DO BEGIN
      TRY
      IF WindowState = wsMaximized THEN WriteBool ( 'window', 'Max', True )
      ELSE BEGIN
         WriteInteger ( 'window', 'Left', Left );
         WriteInteger ( 'window', 'Top', Top );
         WriteInteger ( 'window', 'Width', Width );
         WriteInteger ( 'window', 'Height', Height );
         WriteBool ( 'window', 'Max', False )
      END;

      WITH Richedit1
      DO BEGIN
         WriteString ( 'editor', 'fontname', font.name );
         WriteInteger ( 'editor', 'fontsize', font.size );
         WriteInteger ( 'editor', 'fontcolor', font.color );
         WriteBool ( 'editor', 'fontstyle.bold', fsbold IN font.style );
         WriteBool ( 'editor', 'fontstyle.italic', fsitalic IN font.style );
         WriteBool ( 'editor', 'fontstyle.underline', fsunderline IN font.style );
         WriteBool ( 'editor', 'fontstyle.strikeout', fsstrikeout IN font.style );
      END;

      // save MRU list
      IF ( OpenedFiles.Count > 0 )
      THEN BEGIN
         IF SectionExists ( 'Files' )
         THEN BEGIN
            ReadSectionValues ( 'Files', t );
            EraseSection ( 'Files' );
            FOR i := Pred ( t.Count ) DOWNTO 0
            DO BEGIN
               s := t [i];
               Delete ( s, 1, Pos ( '=', s ) );
               t [i] := s;
            END;
         END;

         WITH OpenedFiles
         DO BEGIN
            AddStrings ( t );
            j := Count - 1;
            IF j > 15 THEN j := 15; // save no more than 16
            FOR i := 0 TO j
            DO BEGIN
                WriteString ( 'Files', inttostr ( i ), OpenedFiles [i] );
            END;
         END;
      END;
      //
      EXCEPT END;
      Free;
   END;
   t.Free;
   OpenedFiles.Free;
END;

procedure TForm1.FormCreate(Sender: TObject);
VAR
i : integer;
s : String;
t : TStringList;
BEGIN
  OpenedFiles := TStringList.Create;
  WITH OpenedFiles
  DO BEGIN
     Sorted := True;
     Duplicates := DupIgnore;
  END;

  Top := 1;
  Left := 1;
  Caption := 'htz ' +
             htz_Version +
             ' (c)' +
             htz_Date + ', ' +
             htz_Author;
  
  srcfile := '';
  destfile := '';
  SaveButton.Enabled := False;
  Save1.Enabled := False;
  CloseButton.Enabled := False;
  Find1.Enabled := CloseButton.Enabled;
  FindButton.Enabled := Find1.Enabled;
  PreviewButton.Enabled := False;
  Close1.Enabled := False;
  IniFile := TIniFile.Create ( ChangeFileExt ( ParamStr ( 0 ), '.ini' ) );
  WITH IniFile
  DO BEGIN
      Left := ReadInteger ( 'window', 'Left', Left );
      Top := ReadInteger ( 'window', 'Top', Top );
      Width := ReadInteger ( 'window', 'Width', Width );
      Height := ReadInteger ( 'window', 'Height', Height );
      IF ReadBool ( 'window', 'Max', False ) THEN WindowState := wsMaximized;

      WITH Richedit1
      DO BEGIN
         font.name := ReadString ( 'editor', 'fontname', font.name );
         font.size := ReadInteger ( 'editor', 'fontsize', font.size );
         font.color := ReadInteger ( 'editor', 'fontcolor', font.color );
         font.style := [];
         IF ReadBool ( 'editor', 'fontstyle.bold', False )
            THEN font.style := font.style  + [fsbold];
         IF ReadBool ( 'editor', 'fontstyle.italic', False )
            THEN font.style := font.style  + [fsitalic];
         IF ReadBool ( 'editor', 'fontstyle.underline', False )
            THEN font.style := font.style  + [fsunderline];
         IF ReadBool ( 'editor', 'fontstyle.strikeout', False )
            THEN font.style := font.style  + [fsstrikeout];

         FontDialog1.Font := Font;
      END;

      // READ MRU list
      IF SectionExists ( 'Files' )
      THEN BEGIN
          t := TStringList.Create;
          ReadSectionValues ( 'Files', t );
          FOR i := Pred ( t.Count ) DOWNTO 0
          DO BEGIN
             s := t [i];
             Delete ( s, 1, Pos ( '=', s ) );
             t [i] := s;
          END;
          OpenedFiles.AddStrings ( t );
          t.free;
          UpdateMRU;
      END;
  END;
  Reopen1.Enabled := OpenedFiles.Count > 0;
  OpenDialog1.Filter := StandardFilter;
  SaveDialog1.Filter := StandardFilter;
END;

procedure TForm1.FormResize(Sender: TObject);
BEGIN
   IF Width < 600 THEN Width := 600;
   IF Height < 430 THEN Height := 430;
   RichEdit1.Height := Height - 90;
   RichEdit1.Width := Width - 8;
   ToolBar1.Width := Width - 8;
   StatusBar1.Width := Width - 8;
END;

procedure TForm1.About1Click(Sender: TObject);
VAR
s : AnsiString;
BEGIN
  s := Caption + #13#10 +
             '(The African Chief)' + #13#10 +
             'Web: ' + MyUrl;
   ShowMessage ( s );
END;

procedure TForm1.Checkforupdates1Click(Sender: TObject);
begin
   ExecuteFile ( UpdateUrl, '', '',  {$ifdef Win32}SW_SHOW{$else}0{$endif} )
end;

procedure TForm1.TheAfricanChiefs1Click(Sender: TObject);
begin
   ExecuteFile ( MyUrl, '', '',  {$ifdef Win32}SW_SHOW{$else}0{$endif} )
end;

procedure TForm1.Undo1Click(Sender: TObject);
begin
   RichEdit1.Undo;
end;

procedure TForm1.Cut1Click(Sender: TObject);
begin
   RichEdit1.CutToClipBoard;
end;

procedure TForm1.Copy1Click(Sender: TObject);
begin
  RichEdit1.CopyToClipboard;
end;

procedure TForm1.Paste1Click(Sender: TObject);
begin
  RichEdit1.PasteFromClipboard;
end;

procedure TForm1.FindDialog1Find(Sender: TObject);
BEGIN
  WITH RichEdit1
  DO BEGIN
    If Search (FindDialog1.FindText,
              (FindDialog1.Options * [frMatchCase] = [frMatchCase]),
               True,
               ( FindDialog1.Options * [frWholeWord] = [frWholeWord]),
               True,
               CaretPos.Line,
               CaretPos.Col)
    THEN BEGIN
      SetFocus;
      UpdateStatus ( Sender );
    END
    ELSE ShowMessage ( 'No (or no more) matches for "' + FindDialog1.FindText + '"' );
  END;
END;

end.
