{ **********************************************************************
  **    THIS CODE IS FREEWARE, AND IS SUPPLIED WITH NO WARRANTIES
  **
  **                  htztool.pas
  **   formerly htz.pas (that name has now gone to the GUI version)
  **
  **    a  program to decompress or create "htz" files
  **    uses the PasZlib libraries from:
  **            http://www.nomssi.de/paszlib/paszlib.html
  **
  **   Author:
  **       Prof Abimbola A Olowofoyeku (The African Chief)
  **            http://www.bigfoot.com/~african_chief/
  **
  **       Version:             1.04.3
  **       Last Modified:       20th May 2004
  **********************************************************************
}

PROGRAM htztool;
{$I-,R-}
{$H+}

{$ifdef Win32}
   {$ifndef VirtualPascal}
     {$apptype console}
   {$endif}
{$endif}

{.$define Use_DLL}  { define to use the htzdll.dll instead of static linking }

USES
SysUtils,
{$ifdef Use_DLL}
htzdll_import;
{$else}
htz_unit;
{$endif}

{ example of callback routine }
FUNCTION MyCallBack ( CONST Data; CONST DataSize : Longint ) : Longint;
STDCALL;
VAR
p : pchar;
BEGIN
   p := pchar ( @Data );
   p [ DataSize ] := #0;
   WRITE ( p );
   Result := Strlen ( p );
END; { MyCallBack }

{ @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ }
{   (main)  }
VAR
s1, s2 : AnsiString;

BEGIN
   s1 := ParamStr ( 1 );
   s2 := ParamStr ( 2 );

   Writeln ( ExtractFileName ( ParamStr ( 0 ) ),
           ' v',
           htz_Version,
           ' - compresses and uncompresses htz files ' );

   Writeln ( '(c)',
           htz_Date,
           ', Prof. A Olowofoyeku (The African Chief)' );

   IF ( ParamCount < 2 )
   THEN BEGIN
      Writeln;
      Writeln ( 'Usage = ',
      ExtractFileName ( ParamStr ( 0 ) ), ' <infile> <outfile> [/compress]' );

      Writeln ( '  Legend: /compress = compress <infile> into <outfile>' );
      Writeln ( '  Default is to DEcompress <infile> into <outfile>' );
      Halt;
   END;

   IF ( ParamCount = 3 ) { compress }
     THEN
   Writeln ( 'Compressed ', CompressFile{Ex}
           ( pChar ( s1 ), PChar ( s2 ) {, MyCallBack} ), ' byte(s)' )
     ELSE
   Writeln ( 'Extracted ',
   UnCompressFile{Ex}
   ( PChar ( s1 ), PChar ( s2 ) {, MyCallBack} ), ' byte(s)' );
END.

