{ **********************************************************************
  **    THIS CODE IS FREEWARE, AND IS SUPPLIED WITH NO WARRANTIES
  **
  **                  htzdll_import.pas
  **
  **    an import unit for the htzdll DLL to decompress or create "htz" files
  **    uses the PasZlib libraries from:
  **            http://www.nomssi.de/paszlib/paszlib.html
  **
  **   Author:
  **       Prof Abimbola A Olowofoyeku (The African Chief)
  **            http://www.greatchief.plus.com/
  **
  **       Version:             1.04.1
  **       Last Modified:       15th May 2004
  **********************************************************************
}
UNIT htzdll_import;

INTERFACE

{ callback function type }
TYPE
htz_CallBack = FUNCTION ( CONST Data; CONST DataSize : Longint ) : Longint STDCALL;
{ data = a buffer containing processed data
  datasize = the size of that data
  Return value: return >= 0 if you want processing to continue, or a negative value
                for processing to stop
}


{ *** high level routines *** }
FUNCTION CompressFile ( Src, Target : pChar ) : Longint; STDCALL;
{
  Compress a file - parameters are source file and target file
  returns negative value if there is an error, else the number of
  bytes written
}

FUNCTION CompressFileEx ( Src, Target : pChar; CallBack : htz_CallBack ) : Longint;
STDCALL;
{
  Compress a file - with callback functionality
}


FUNCTION UnCompressFile ( Src, Target : pChar ) : Longint; STDCALL;
{
  uncompress a file -
  parameters are source file and target file
  returns negative value if there is an error, else the number of
  bytes extracted
}

FUNCTION UnCompressFileEx ( Src, Target : pChar; CallBack : htz_CallBack  ) : Longint;
STDCALL;
{
  uncompress a file - with callback functionality
}

FUNCTION IsHTZFile ( FName : pChar ) : Longint; STDCALL;
{ rudimentary check for whether a file is an HTZ or other zlib file
  returns > 0 if yes, and <= 0 if not
}

FUNCTION htz_Version : pChar; STDCALL;
{ returns the version number
}

FUNCTION htz_Author : pChar; STDCALL;
{ returns the author's Thedll
}

FUNCTION htz_Date : pChar; STDCALL;
{ returns the date of the library
}

FUNCTION HTZFileSize ( FName : pChar ) : Longint; STDCALL;
{return the uncompressed size of the HTZ file (if it is one) or
 actual file size
}

IMPLEMENTATION

CONST htzdll = 'htzdll.dll';

FUNCTION CompressFile;        external htzdll name 'CompressFile';
FUNCTION CompressFileEx;      external htzdll name 'CompressFileEx';
FUNCTION UnCompressFile;      external htzdll name 'UnCompressFile';
FUNCTION UnCompressFileEx;    external htzdll name 'UnCompressFileEx';
FUNCTION IsHTZFile;           external htzdll name 'IsHTZFile';
FUNCTION HTZFileSize;         external htzdll name 'HTZFileSize';
FUNCTION htz_Version;         external htzdll name 'htz_Version';
FUNCTION htz_Author;          external htzdll name 'htz_Author';
FUNCTION htz_Date;            external htzdll name 'htz_Date';

BEGIN
END.

