{ **********************************************************************
  **    THIS CODE IS FREEWARE, AND IS SUPPLIED WITH NO WARRANTIES
  **
  **                  htz_gui_unit.pas
  **
  **    a GUI unit to decompress or create "htz" files
  **    uses the PasZlib libraries from:
  **            http://www.nomssi.de/paszlib/paszlib.html
  **
  **   Author:
  **       Prof Abimbola A Olowofoyeku (The African Chief)
  **            http://www.greatchief.plus.com/
  **
  **       Version:             1.04.5
  **       Last Modified:       11th July 2004
  **********************************************************************
}

UNIT htz_gui_unit;

INTERFACE
{$h+}

{$ifdef Win32}
USES
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, IniFiles, Menus, ExtCtrls, ToolWin;
{$else}
uses
  SysUtils, Types, Classes, Variants, QTypes, QGraphics, QControls, QForms,
  QDialogs, QStdCtrls;
{$endif}
TYPE
  TForm1 = CLASS ( TForm )
    RichEdit1 : TRichEdit;
    OpenDialog1 : TOpenDialog;
    SaveDialog1 : TSaveDialog;
    MainMenu1 : TMainMenu;
    File1 : TMenuItem;
    Open1 : TMenuItem;
    Close1 : TMenuItem;
    Save1 : TMenuItem;
    Help1 : TMenuItem;
    About1 : TMenuItem;
    N1 : TMenuItem;
    Exit1 : TMenuItem;
    StatusBar1 : TStatusBar;
    Format1 : TMenuItem;
    Font1 : TMenuItem;
    FontDialog1 : TFontDialog;
    ToolBar1 : TToolBar;
    OpenButton : TSpeedButton;
    CloseButton : TSpeedButton;
    SaveButton : TSpeedButton;
    FontButton : TSpeedButton;
    ExitButton : TSpeedButton;
    Edit1 : TMenuItem;
    Undo1 : TMenuItem;
    Cut1 : TMenuItem;
    Copy1 : TMenuItem;
    Paste1 : TMenuItem;
    N2 : TMenuItem;
    Delete1 : TMenuItem;
    N3 : TMenuItem;
    GototheChiefswebsite1 : TMenuItem;
    N4 : TMenuItem;
    Batchconvert1 : TMenuItem;
    FromHTZ1 : TMenuItem;
    ToHTZ1 : TMenuItem;
    View1 : TMenuItem;
    Preview1 : TMenuItem;
    PreviewButton : TSpeedButton;
    N5 : TMenuItem;
    Update1 : TMenuItem;
    N6 : TMenuItem;
    Find1 : TMenuItem;
    FindDialog1 : TFindDialog;
    ReplaceDialog1 : TReplaceDialog;
    LinkButton : TSpeedButton;
    FindButton : TSpeedButton;
    Reopen1 : TMenuItem;
    PROCEDURE ExitBitBtnClick ( Sender : TObject );
    PROCEDURE OpenBitBtnClick ( Sender : TObject );
    PROCEDURE FormResize ( Sender : TObject );
    PROCEDURE FormCreate ( Sender : TObject );
    PROCEDURE CloseBitBtnClick ( Sender : TObject );
    PROCEDURE SaveBitBtnClick ( Sender : TObject );
    PROCEDURE FormClose ( Sender : TObject; VAR Action : TCloseAction );
    PROCEDURE About1Click ( Sender : TObject );
    PROCEDURE Font1Click ( Sender : TObject );
    PROCEDURE RichEdit1KeyDown ( Sender : TObject; VAR Key : Word;
      Shift : TShiftState );
    PROCEDURE Copy1Click ( Sender : TObject );
    PROCEDURE Undo1Click ( Sender : TObject );
    PROCEDURE Paste1Click ( Sender : TObject );
    PROCEDURE Cut1Click ( Sender : TObject );
    PROCEDURE Delete1Click ( Sender : TObject );
    PROCEDURE Edit1Click ( Sender : TObject );
    PROCEDURE GototheChiefswebsite1Click ( Sender : TObject );
    PROCEDURE FromHTZ1Click ( Sender : TObject );
    PROCEDURE ToHTZ1Click ( Sender : TObject );
    PROCEDURE Preview1Click ( Sender : TObject );
    PROCEDURE View1Click ( Sender : TObject );
    PROCEDURE FormActivate ( Sender : TObject );
    PROCEDURE Update1Click ( Sender : TObject );
    PROCEDURE Find1Click ( Sender : TObject );
    PROCEDURE FindDialog1Find ( Sender : TObject );
    PROCEDURE LinkButtonClick ( Sender : TObject );
    PROCEDURE RichEdit1SelectionChange ( Sender : TObject );
    PROCEDURE RichEdit1Enter ( Sender : TObject );
  PRIVATE
    { Private declarations }
    OpenedFiles : TStringList;
    PROCEDURE CheckSave;
    PROCEDURE UpdateStatus ( Sender : TObject );
    PROCEDURE SubMenuClick ( Sender : TObject );
    FUNCTION  EditingHtm : Boolean;
    FUNCTION  TextAtCursor : String;
    PROCEDURE UpdateMRU;
  PUBLIC
    { Public declarations }
    PROCEDURE OpenHTZFile ( CONST FName : String );
  END;

VAR
  Form1 : TForm1;

IMPLEMENTATION
{.$define Use_DLL}  { define to use the htzdll.dll instead of static linking }

USES
{$ifdef Win32}
FileCtrl,
ShellAPI,
Richedit,
{$endif}
{$ifdef Use_DLL}
htzdll_import;
{$else}
htz_unit;
{$endif}

{$R *.DFM}

CONST
Slash = {$ifdef Win32}'\'{$else} '/'{$endif};
MaxExtensions = 4;
Extensions : ARRAY [1..MaxExtensions] OF String = ( 'htz', 'htm', 'txt', '' );
htz_filter = 1;
htm_filter = 2;
txt_filter = 3;
all_filter = 4;
StandardFilter = 'HTZ files|*.htz;*.*_z|HTML files|*.htm|Text files|*.txt|All files|*.*';
MyUrl = 'http://www.greatchief.plus.com/';
UpdateUrl = 'http://www.greatchief.plus.com/origo.htm';

VAR
tmp,
srcfile,
destfile : string;
IniFile : TIniFile;
www : Word;

{ utility functions }
FUNCTION GetEnvVAR ( CONST Env : String ) : String;
VAR
p2 : pChar;
i  : Integer;
s  : String;
BEGIN
    Result := '';
    p2 := GetEnvironmentStrings;
    WHILE p2 [0] <> #0
    DO BEGIN
      s := StrPas ( p2 );
      IF ( Pos ( UpperCase ( Env ), UpperCase ( s ) ) = 1 )
      THEN BEGIN
        i := Pos ( '=', s );
        IF i = 0 THEN i := pos ( #32, s );
        Delete ( s, 1, i );
        Result := s;
        Exit;
      END;
      WHILE ( p2 [0] <> #0 ) DO Inc ( p2 ); { goto end of current }
      Inc ( p2 ); { point to next }
    END;
    FreeEnvironmentStrings ( p2 );
END; { GetEnvVAR }

FUNCTION TempDirectory : String;
VAR
TempDir : String;
BEGIN
  TempDir := '';
  TempDir := GetEnvVar ( 'TEMP' );
  IF TempDir = '' THEN TempDir := GetEnvVar ( 'TMP' );
  IF TempDir = ''
  THEN BEGIN
     TempDir := 'c:\temp';
     IF DirectoryExists ( TempDir ) THEN {}
     ELSE BEGIN
         Mkdir ( Tempdir );
         IF ioresult <> 0 THEN Tempdir := 'c:\';
     END;
  END;
  Result := TempDir;
END; { TempDirectory }

FUNCTION AddBackSlash ( CONST s : String ) : String;
BEGIN
   IF ( s [length ( s ) ] = Slash )
     THEN Result := s
        ELSE Result := s + Slash;
END; { AddBackSlash }

FUNCTION JustExtension ( CONST s : String ) : String;
BEGIN
   Result := ExtractFileExt ( s );
   IF ( Result > '' ) AND ( Result [1] = '.' ) THEN Delete ( Result, 1, 1 );
END; { JustExtension }

FUNCTION FindFilterIndex ( CONST s : String ) : Byte;
VAR
s1 : String;
i : Byte;
BEGIN
   Result := htm_filter;
   s1 := ExtractFileExt ( s );
   IF s1 > ''
   THEN BEGIN
      Delete ( s1, Pos ( '.', s1 ), 1 );
      i := 1;
      WHILE i < 4
      DO BEGIN
        IF AnsiCompareText ( s1, Extensions [i] ) = 0
        THEN BEGIN
           Result := i;
           Exit;
        END;
        Inc ( i );
      END;
      Result := i;
   END;
END; { GetFilterIndex }

{ callback routine }
FUNCTION MyCallBack ( CONST Data; CONST DataSize : Longint ) : Longint; STDCALL;
VAR
p : pchar;
BEGIN
   p := pchar ( @Data );
   p [ DataSize ] := #0;
   Form1.RichEdit1.Lines.Add ( p );
   Result := Strlen ( p );
END; { MyCallBack }

{ form1 methods }
PROCEDURE TForm1.ExitBitBtnClick ( Sender : TObject );
BEGIN
    Close;
END;

PROCEDURE TForm1.CheckSave;
BEGIN
   WITH RichEdit1
   DO BEGIN
      IF Modified
      THEN BEGIN
         IF MessageBox ( Handle, 'Do you want to save the file?', 'Attention',
         mb_YesNo ) = IDYes
           THEN SaveBitBtnClick ( Self );
         CloseBitBtnClick ( Self );
      END;
      Clear;
      Modified := False;
   END;
END;

PROCEDURE TForm1.SubMenuClick ( Sender : TObject );
BEGIN
   WITH TMenuItem ( Sender )
   DO BEGIN
      OpenHTZFile ( Caption );
   END;
END;

PROCEDURE TForm1.UpdateMRU;
VAR
i : longint;
t : TMenuItem;
BEGIN
   FOR i := ReOpen1.Count - 1 DOWNTO 0
   DO BEGIN
       Reopen1.Delete ( i );
   END;

   FOR i := 0 TO OpenedFiles.Count - 1
   DO BEGIN
      t := TMenuItem.Create ( Self );
      WITH t DO BEGIN
           Caption := OpenedFiles [i];
           MenuIndex := 0;
           OnClick := SubMenuClick;
      END;
      Reopen1.Add ( t );
   END;
END;

PROCEDURE TForm1.OpenHTZFile ( CONST FName : String );
VAR
src, dest : string;
i : longint;
BEGIN
   IF Trim ( FName ) = '' THEN Exit;
   CheckSave;
   OpenDialog1.FileName := FName;
   src := OpenDialog1.FileName;
   SaveDialog1.FilterIndex := FindFilterIndex ( src );
   i := IsHTZFile ( pChar ( src ) );
   LinkButton.Enabled := RichEdit1.SelText > '';
   IF i > 0
   THEN BEGIN
      dest := ChangeFileExt ( src, '.tmp' );
      RichEdit1.Lines.Clear;
      IF UnCompressFileEx ( pChar ( src ), pChar ( dest ), MyCallBack ) > 0
      THEN BEGIN
        srcfile := src;
        destfile := dest;
        SaveButton.Enabled := True;
        Save1.Enabled := True;
        CloseButton.Enabled := True;
        Find1.Enabled := CloseButton.Enabled;
        FindButton.Enabled := Find1.Enabled;
        PreviewButton.Enabled := EditingHtm;
        Close1.Enabled := True;
      END;
      DeleteFile ( dest );
   END
   ELSE BEGIN
        RichEdit1.Lines.LoadFromFile ( src );
        srcfile := src;
        destfile := src;
        SaveButton.Enabled := True;
        Save1.Enabled := True;
        CloseButton.Enabled := True;
        Find1.Enabled := CloseButton.Enabled;
        FindButton.Enabled := Find1.Enabled;
        PreviewButton.Enabled := EditingHtm;
        Close1.Enabled := True;
   END; { isHTZFile }

   Reopen1.Enabled := True;
   SaveDialog1.FileName := srcfile;
   StatusBar1.SimpleText := srcfile;
   OpenedFiles.Add ( srcfile );
   
   WITH RichEdit1
   DO BEGIN
      Modified := False;
      SetFocus;
      www := VK_Control OR VK_Home;
      OnKeyDown ( Self, www, [] );

      // scroll TO beginning
      Perform ( WM_VSCROLL, sb_Top, 0 );
      SelStart := 0;
      SelLength := 0;
      perform ( em_scrollcaret, 0, 0 );
   END;
   UpdateMRU;
END;

PROCEDURE TForm1.OpenBitBtnClick ( Sender : TObject );
BEGIN
   IF OpenDialog1.Execute
   THEN BEGIN
      OpenHTZFile ( OpenDialog1.FileName );
   END;
END;

PROCEDURE TForm1.FormResize ( Sender : TObject );
BEGIN
   IF Width < 410 THEN Width := 410;
   IF Height < 280 THEN Height := 280;
   RichEdit1.Height := Height - 140;
   RichEdit1.Width := Width - 8;
   ToolBar1.Width := Width - 8;
   StatusBar1.Width := Width - 8;
END;

PROCEDURE TForm1.FormCreate ( Sender : TObject );
VAR
i : integer;
s : String;
t : TStringList;
BEGIN
  OpenedFiles := TStringList.Create;
  WITH OpenedFiles
  DO BEGIN
     Sorted := True;
     Duplicates := DupIgnore;
  END;

  Top := 1;
  Left := 1;
  Caption := 'htz ' +
             htz_Version +
             ' (c)' +
             htz_Date + ', ' +
             htz_Author;
  
  srcfile := '';
  destfile := '';
  SaveButton.Enabled := False;
  Save1.Enabled := False;
  CloseButton.Enabled := False;
  Find1.Enabled := CloseButton.Enabled;
  FindButton.Enabled := Find1.Enabled;
  PreviewButton.Enabled := False;
  Close1.Enabled := False;
  IniFile := TIniFile.Create ( ChangeFileExt ( ParamStr ( 0 ), '.ini' ) );
  WITH IniFile
  DO BEGIN
      Left := ReadInteger ( 'window', 'Left', Left );
      Top := ReadInteger ( 'window', 'Top', Top );
      Width := ReadInteger ( 'window', 'Width', Width );
      Height := ReadInteger ( 'window', 'Height', Height );
      IF ReadBool ( 'window', 'Max', False ) THEN WindowState := wsMaximized;

      WITH Richedit1
      DO BEGIN
         font.name := ReadString ( 'editor', 'fontname', font.name );
         font.size := ReadInteger ( 'editor', 'fontsize', font.size );
         font.color := ReadInteger ( 'editor', 'fontcolor', font.color );
         font.style := [];
         IF ReadBool ( 'editor', 'fontstyle.bold', False )
            THEN font.style := font.style  + [fsbold];
         IF ReadBool ( 'editor', 'fontstyle.italic', False )
            THEN font.style := font.style  + [fsitalic];
         IF ReadBool ( 'editor', 'fontstyle.underline', False )
            THEN font.style := font.style  + [fsunderline];
         IF ReadBool ( 'editor', 'fontstyle.strikeout', False )
            THEN font.style := font.style  + [fsstrikeout];

         FontDialog1.Font := Font;
      END;

      // READ MRU list
      IF SectionExists ( 'Files' )
      THEN BEGIN
          t := TStringList.Create;
          ReadSectionValues ( 'Files', t );
          FOR i := Pred ( t.Count ) DOWNTO 0
          DO BEGIN
             s := t [i];
             Delete ( s, 1, Pos ( '=', s ) );
             t [i] := s;
          END;
          OpenedFiles.AddStrings ( t );
          t.free;
          UpdateMRU;
      END;
  END;
  Reopen1.Enabled := OpenedFiles.Count > 0;
  OpenDialog1.Filter := StandardFilter;
  SaveDialog1.Filter := StandardFilter;
END;

PROCEDURE TForm1.CloseBitBtnClick ( Sender : TObject );
BEGIN
  srcfile := '';
  destfile := '';
  Richedit1.Lines.Clear;
  SaveButton.Enabled := False;
  Save1.Enabled := False;
  CloseButton.Caption := 'Close';
  Close1.Caption := 'Close';
  CloseButton.Enabled := False;
  Find1.Enabled := CloseButton.Enabled;
  FindButton.Enabled := Find1.Enabled;
  PreviewButton.Enabled := False;
  Close1.Enabled := False;
  UpdateStatus ( Self );
END;

PROCEDURE TForm1.SaveBitBtnClick ( Sender : TObject );
BEGIN
   WITH RichEdit1
   DO BEGIN
       IF ( Lines.Count > 0 )
       THEN BEGIN
          IF SaveDialog1.Execute
          THEN BEGIN
             SaveDialog1.DefaultExt := Extensions [SaveDialog1.filterindex];
             SaveDialog1.filename := ChangeFileExt ( SaveDialog1.filename, '.' + SaveDialog1.DefaultExt );
             IF ( SaveDialog1.filterindex = htz_filter ) { compress to HTZ file }
             THEN BEGIN
                 destfile := SaveDialog1.FileName + '.tm$';
                 Lines.SaveToFile ( destfile );
                 IF CompressFile ( pChar ( destfile ), pChar ( SaveDialog1.FileName ) ) < 1
                 THEN BEGIN
                    ShowMessage ( 'Error writing to ' + SaveDialog1.FileName );
                 END;
                 DeleteFile ( destfile );
                 destfile := SaveDialog1.FileName;
             END
             ELSE BEGIN { save to HTML or text or other file }
                 destfile := SaveDialog1.FileName;
                 Lines.SaveToFile ( destfile );
             END;
             StatusBar1.SimpleText := destfile;
             Modified := False;
             SaveDialog1.filterindex := htm_filter;
             SaveDialog1.DefaultExt := Extensions [SaveDialog1.filterindex];
          END;
       END;
   END;
END;

PROCEDURE TForm1.FormClose ( Sender : TObject; VAR Action : TCloseAction );
VAR
t : TStringList;
i, j : Integer;
s : String;
BEGIN
   CheckSave;
   t := TStringList.Create;
   t.Duplicates := DupIgnore;
   WITH IniFile
   DO BEGIN
      TRY
      IF WindowState = wsMaximized THEN WriteBool ( 'window', 'Max', True )
      ELSE BEGIN
         WriteInteger ( 'window', 'Left', Left );
         WriteInteger ( 'window', 'Top', Top );
         WriteInteger ( 'window', 'Width', Width );
         WriteInteger ( 'window', 'Height', Height );
         WriteBool ( 'window', 'Max', False )
      END;

      WITH Richedit1
      DO BEGIN
         WriteString ( 'editor', 'fontname', font.name );
         WriteInteger ( 'editor', 'fontsize', font.size );
         WriteInteger ( 'editor', 'fontcolor', font.color );
         WriteBool ( 'editor', 'fontstyle.bold', fsbold IN font.style );
         WriteBool ( 'editor', 'fontstyle.italic', fsitalic IN font.style );
         WriteBool ( 'editor', 'fontstyle.underline', fsunderline IN font.style );
         WriteBool ( 'editor', 'fontstyle.strikeout', fsstrikeout IN font.style );
      END;

      // save MRU list
      IF ( OpenedFiles.Count > 0 )
      THEN BEGIN
         IF SectionExists ( 'Files' )
         THEN BEGIN
            ReadSectionValues ( 'Files', t );
            EraseSection ( 'Files' );
            FOR i := Pred ( t.Count ) DOWNTO 0
            DO BEGIN
               s := t [i];
               Delete ( s, 1, Pos ( '=', s ) );
               t [i] := s;
            END;
         END;

         WITH OpenedFiles
         DO BEGIN
            AddStrings ( t );
            j := Count - 1;
            IF j > 15 THEN j := 15; // save no more than 16
            FOR i := 0 TO j
            DO BEGIN
                WriteString ( 'Files', inttostr ( i ), OpenedFiles [i] );
            END;
         END;
      END;
      //
      EXCEPT END;
      Free;
   END;
   t.Free;
   OpenedFiles.Free;
END;

PROCEDURE TForm1.About1Click ( Sender : TObject );
VAR
s : AnsiString;
BEGIN
  s := Caption + #13#10 +
             '(The African Chief)' + #13#10 +
             'Web: ' + MyUrl;
   MessageBox ( Handle, pChar ( s ), 'About htz', 0 );
END;

PROCEDURE TForm1.Font1Click ( Sender : TObject );
BEGIN
  WITH FontDialog1 DO BEGIN
      IF Execute THEN RichEdit1.Font := Font;
  END;
END;

PROCEDURE TForm1.UpdateStatus ( Sender : TObject );
VAR
MemoLine,
Memo_column : integer;
BEGIN
   WITH RichEdit1
   DO BEGIN
      LinkButton.Enabled := SelText > '';
      IF Lines.Count = 0 THEN StatusBar1.SimpleText := ''
      ELSE BEGIN
         MemoLine := Perform ( EM_LINEFROMCHAR, SelStart, 0 );
         Memo_column  := SelStart - Perform ( EM_LINEINDEX, MemoLine, 0 );
         StatusBar1.SimpleText :=
         inttostr ( Lines.Count ) + ' lines, ' +
         inttostr ( MemoLine + 1 ) + ' : ' + inttostr ( Memo_column + 1 ) + '  (' + srcfile + ')';
      END;
   END;
END;

PROCEDURE TForm1.RichEdit1KeyDown ( Sender : TObject; VAR Key : Word;
  Shift : TShiftState );
BEGIN
  UpdateStatus ( Sender );
END;

PROCEDURE TForm1.Copy1Click ( Sender : TObject );
BEGIN
   WITH Richedit1 DO BEGIN
     Perform ( Wm_Copy, 0, 0 );
   END;
END;

PROCEDURE TForm1.Undo1Click ( Sender : TObject );
BEGIN
   WITH Richedit1 DO BEGIN
     Perform ( wm_Undo, 0, 0 );
   END;
END;

PROCEDURE TForm1.Paste1Click ( Sender : TObject );
BEGIN
   WITH Richedit1 DO BEGIN
     Perform ( Wm_Paste, 0, 0 );
   END;
END;

PROCEDURE TForm1.Cut1Click ( Sender : TObject );
BEGIN
   WITH Richedit1 DO BEGIN
     Perform ( Wm_Cut, 0, 0 );
   END;
END;

PROCEDURE TForm1.Delete1Click ( Sender : TObject );
BEGIN
   WITH Richedit1
   DO BEGIN
     RichEdit1.SelText;
     Perform ( Wm_Clear, 0, 0 );
   END;
END;

PROCEDURE TForm1.Edit1Click ( Sender : TObject );
BEGIN
   WITH Richedit1
   DO BEGIN
      IF SelText = ''
      THEN BEGIN
         Copy1.Enabled := False;
         Cut1.Enabled := False;
         Delete1.Enabled := False;
      END
      ELSE BEGIN
         Copy1.Enabled := True;
         Cut1.Enabled := True;
         Delete1.Enabled := True;
      END;
      {$ifdef Win32}
      Paste1.Enabled := Perform ( EM_CANPASTE, 0, 0 ) > 0;
      Undo1.Enabled := Perform ( EM_CANUNDO, 0, 0 ) > 0;
      {$endif}
   END;
END;

FUNCTION ExecuteFile ( CONST FileName, Params, DefaultDir : string;
  ShowCmd : Integer ) : THandle;
VAR
  zFileName, zParams, zDir : ARRAY [0..79] OF Char;
BEGIN
  Result := ShellExecute ( Application.MainForm.Handle, NIL,
    StrPCopy ( zFileName, FileName ), StrPCopy ( zParams, Params ),
    StrPCopy ( zDir, DefaultDir ), ShowCmd );
END;

PROCEDURE TForm1.GototheChiefswebsite1Click ( Sender : TObject );
BEGIN
   ExecuteFile ( MyUrl, '', '', SW_SHOW )
END;

{ batch conversion }
CONST
MaxConverts = 5;
HTZExtensions : ARRAY [1..MaxConverts] OF string =
( 'htz', 'htz', 'jsz', 'dlz', 'z' );

NormalExtensions : ARRAY [1..MaxConverts] OF string =
( 'htm', 'html', 'js', 'dl', '' );

PROCEDURE TForm1.FromHTZ1Click ( Sender : TObject );
VAR
i, j : Cardinal;
f, s, s1, s2 : String;
BEGIN
  CheckSave;
  WITH OpenDialog1
  DO BEGIN
     f := Filter;
     Filter := 'HTZ files|*.htz;*.jsz;*.dlz;*.z;*.*_z';
     tmp := Title;
     Title := 'Decompress HTZ format file(s)';
     Options := Options + [ofAllowMultiSelect];
     FilterIndex := htz_filter;
     IF Execute
     THEN BEGIN
        IF NOT SelectDirectory ( s2, [sdAllowCreate, sdPerformCreate, sdPrompt], - 1 )
        THEN Exit;

        FOR i := 0 TO Pred ( Files.Count )
        DO
        IF IsHTZFile ( pChar ( Files [i] ) ) > 0   // test TO see that it IS an HTZ FILE
        THEN BEGIN
           s := JustExtension ( Files [i] );
           IF ( s > '' ) AND ( Pos ( '_z', LowerCase ( s ) ) > 0 )
           THEN BEGIN
              s1 := Files [i];
              Delete ( s1, Length ( s1 ) - 1, 2 )
           END ELSE s1 := ChangeFileExt ( Files [i], '.htm' );

           FOR j := 1 TO MaxConverts
           DO
           IF AnsiCompareText ( s, HTZExtensions [j] ) = 0
           THEN BEGIN
               s1 := ChangeFileExt ( s1, '.' + NormalExtensions [j] );
               Break;
           END;

           s1 := AddBackSlash ( s2 ) + ExtractFileName ( s1 );
           IF UnCompressFile ( pChar ( Files [i] ), pChar ( s1 ) ) > 0
           THEN BEGIN
              RichEdit1.Lines.Add ( Files [i] + ' ----> ' + s1 );
           END;
        END;
        IF RichEdit1.Lines.Count > 0
        THEN BEGIN
           CloseButton.Caption := 'Clear';
           Close1.Caption := 'Clear';
           CloseButton.Enabled := True;
           Find1.Enabled := CloseButton.Enabled;
           FindButton.Enabled := Find1.Enabled;
           Close1.Enabled := True;
        END;
        RichEdit1.Modified := False;
     END;
     Title := tmp;
     Options := Options - [ofAllowMultiSelect];
     Filter := f;
  END;
END;

PROCEDURE TForm1.ToHTZ1Click ( Sender : TObject );
VAR
i, j : Cardinal;
s, s1, s2 : String;
BEGIN
  CheckSave;
  WITH OpenDialog1
  DO BEGIN
     tmp := Title;
     Title := 'Convert files(s) to HTZ format';
     Options := Options + [ofAllowMultiSelect];
     FilterIndex := all_filter;
     IF Execute
     THEN BEGIN
        IF NOT SelectDirectory ( s2, [sdAllowCreate, sdPerformCreate, sdPrompt], - 1 )
        THEN Exit;

        FOR i := 0 TO Pred ( Files.Count )
        DO
        IF IsHTZFile ( pChar ( Files [i] ) ) <= 0 // test TO see that it IS NOT an HTZ FILE
        THEN BEGIN
           s := JustExtension ( Files [i] );
           IF s > '' THEN BEGIN
              s1 := Files [i] + '_z';     // e.g., foo.pas - > foo.pas_z
           END ELSE s1 := ChangeFileExt ( Files [i], '.z' );

           FOR j := 1 TO MaxConverts DO
           IF AnsiCompareText ( s, NormalExtensions [j] ) = 0
           THEN BEGIN
               s1 := ChangeFileExt ( s1, '.' + HTZExtensions [j] );
               Break;
           END;

           s1 := AddBackSlash ( s2 ) + ExtractFileName ( s1 );
           IF CompressFile ( pChar ( Files [i] ), pChar ( s1 ) ) > 0
           THEN BEGIN
              RichEdit1.Lines.Add ( Files [i] + ' ----> ' + s1 );
           END;
        END;
        IF RichEdit1.Lines.Count > 0
        THEN BEGIN
           CloseButton.Caption := 'Clear';
           Close1.Caption := 'Clear';
           CloseButton.Enabled := True;
           Find1.Enabled := CloseButton.Enabled;
           FindButton.Enabled := Find1.Enabled;
           Close1.Enabled := True;
        END;
        RichEdit1.Modified := False;
     END;
     Title := tmp;
     Options := Options - [ofAllowMultiSelect];
  END;
END;

{ a simple test to check whether we are editing an HTML file }
FUNCTION  TForm1.EditingHtm : Boolean;
VAR
s : String;
BEGIN
   Result := False;
   WITH RichEdit1
   DO BEGIN
      IF ( Lines.Count > 0 )
      THEN BEGIN
         s := UpperCase ( Lines.Text );
         Result :=
         ( 
                ( Pos ( '<HTML>', s ) > 0 )
         OR     ( Pos ( '<TITLE>', s ) > 0 )
         OR     ( Pos ( '<BODY>', s ) > 0 )
         OR     ( Pos ( '<HEAD>', s ) > 0 )
         )
         AND
         ( 
                ( Pos ( '</HTML>', s ) > 0 )
         OR     ( Pos ( '</TITLE>', s ) > 0 )
         OR     ( Pos ( '</BODY>', s ) > 0 )
         OR     ( Pos ( '</HEAD>', s ) > 0 )
         )
      END;
   END;
END;

{ preview html file in web browser }
PROCEDURE TForm1.Preview1Click ( Sender : TObject );
VAR
s : String;
BEGIN
   WITH RichEdit1 DO
   IF EditingHtm
   THEN BEGIN
      {
      s := AddBackSlash (TempDirectory) + ExtractFileName (srcfile);
      s := ChangeFileExt (s, '.htm');
      }
      s := AddBackSlash ( TempDirectory ) + '$tmp$$.htm';
      Lines.SaveToFile ( s );
      ExecuteFile ( s, '', '', SW_SHOW );
      // DeleteFile ( s );
   END;
END;

PROCEDURE TForm1.View1Click ( Sender : TObject );
BEGIN
   Preview1.Enabled := EditingHtm;
END;

PROCEDURE TForm1.FormActivate ( Sender : TObject );
BEGIN
   IF ParamCount > 0 THEN OpenHTZFile ( ParamStr ( 1 ) );
END;

PROCEDURE TForm1.Update1Click ( Sender : TObject );
BEGIN
   ExecuteFile ( UpdateUrl, '', '', SW_SHOW )
END;

FUNCTION TForm1.TextAtCursor : String;
VAR
s : string;
i, j : Longint;
BEGIN
  WITH RichEdit1
  DO BEGIN
     IF SelText > ''
     THEN BEGIN
        Result := SelText;
        Exit;
     END;

     SelLength := 25;
     s := SelText;
     s := Trim ( s );
     SelLength := 0;
     FOR i := 2 TO length ( s )
     DO BEGIN
         IF s [i] IN [#13, #10, #32, ',', ':', '=', ';', '.', '+']
         THEN BEGIN
            j := i;
            Delete ( s, j, length ( s ) );
            Break;
         END;
     END;
     Result := s;
  END;
END;

PROCEDURE TForm1.Find1Click ( Sender : TObject );
VAR
s : String;
BEGIN
   WITH FindDialog1
   DO BEGIN
      FindText := '';
      s := TextAtCursor;
      IF s <> '' THEN FindText := s;
      Options := [frHideUpDown, frDown];
      Execute;
   END;
END;

PROCEDURE TForm1.FindDialog1Find ( Sender : TObject );
VAR
FoundAt : LongInt;
StartPos, ToEnd : integer;
RichOptions : TSearchTypes;
T : TPoint;
BEGIN
  RichOptions := [];
  WITH FindDialog1 DO BEGIN
    IF ( Options * [frWholeWord] ) = [frWholeWord]
       THEN Include ( RichOptions, stWholeWord );

    IF ( Options * [frMatchCase] ) = [frMatchCase]
       THEN Include ( RichOptions, stMatchCase );
  END;

  WITH RichEdit1
  DO BEGIN
    T := CaretPos; // save current

    { begin the search after the current selection if there is one }
    { otherwise, begin at the start of the text }
    IF SelLength <> 0
      THEN StartPos := SelStart + SelLength
         ELSE StartPos := 0;

    { ToEnd is the length from StartPos to the end of the text in the rich edit control }
    ToEnd := Length ( Text ) - StartPos;

    FoundAt := FindText ( FindDialog1.FindText, StartPos, ToEnd, RichOptions );
    IF FoundAt <> - 1
    THEN BEGIN
      SetFocus;
      SelStart := FoundAt;
      SelLength := Length ( FindDialog1.FindText );
      Perform ( EM_LineScroll, CaretPos.X - T.X, CaretPos.Y - T.Y );
      UpdateStatus ( Sender );
    END
    ELSE ShowMessage ( 'No (or no more) matches for "' + FindDialog1.FindText + '"' );
  END;
END;

PROCEDURE TForm1.LinkButtonClick ( Sender : TObject );
VAR
s : String;
BEGIN
   s := '';
   IF ( RichEdit1.SelText > '' ) THEN
      WITH RichEdit1
      DO BEGIN
          s := InputBox ( 'Create Hyperlink for "' + SelText + '"',
                        'URL for "' + Seltext + '"',
                        'http://www.' );
          IF ( s <> '' ) AND ( s <> 'http://www.' )
          THEN BEGIN
             SelText := '<a href="' + s + '">' + Seltext + '</a>';
          END;
      END;
END;

PROCEDURE TForm1.RichEdit1SelectionChange ( Sender : TObject );
BEGIN
  LinkButton.Enabled := RichEdit1.SelText > '';
END;

PROCEDURE TForm1.RichEdit1Enter ( Sender : TObject );
BEGIN
  LinkButton.Enabled := RichEdit1.SelText > '';
END;

END.
